<?php
/**
 * Holds LearnDash related functioanlity for IAP.
 *
 * @package BuddyBossApp\InAppPurchases
 */

namespace BuddyBossApp\InAppPurchases;

use BuddyBossApp\Admin\InAppPurchases\Helpers;
use BuddyBossApp\Integrations\Learndash\Main;
use BuddyBossApp\Tools\Logger;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * LearnDash rest class.
 */
final class LearnDashIapRest {

	/**
	 * Class instance.
	 *
	 * @var null $instance
	 */
	private static $instance = null;

	/**
	 * Product property.
	 *
	 * @var string $rest_response_product_property
	 */
	protected $rest_response_product_property = 'bbapp_products';

	/**
	 * LearnDashIapRest rest constructor.
	 */
	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * Get the instance of this class.
	 *
	 * @return object
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			$class_name     = __CLASS__;
			self::$instance = new $class_name();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Define all actions and filters here
	 */
	public function hooks() {
		// Learner API Integration.
		add_filter( 'bbapp_ld_rest_prepare_course', array( $this, 'rest_integrate_iap_product' ), 20, 3 );
	}

	/**
	 * Verify need of InAppPurchase(bbapp_products) details in course-response.
	 *
	 * @param object $response Response object.
	 * @param object $post     Post object.
	 * @param object $request  Request object.
	 *
	 * @return mixed
	 */
	public function rest_integrate_iap_product( $response, $post, $request ) {
		// LearnDash group now working when we pass integration type.
		$iap_product_href = rest_url( 'buddyboss-app/iap/v1/products/integration/' . $response->data['id'] );
		$response->add_link(
			'iap_products',
			$iap_product_href,
			array(
				'href'       => $iap_product_href,
				'embeddable' => true,
			)
		);

		// This thing keep here only for backward support.
		if ( class_exists( 'BuddyBossApp\Api\Learner\LearnDash\Main' ) ) {
			$response->data = $this->rest_iap_product_response( $response->data, $response->data['id'] );
		}

		return $response;
	}

	/**
	 * Adds InAppPurchase object into rest endpoint of attached one.
	 *
	 * @param object $rest_item Rest object.
	 * @param int    $item_id   Item id.
	 *
	 * @return array|object
	 */
	public function rest_iap_product_response( $rest_item, $item_id ) {

		if ( IAP_LOG ) {
			Logger::instance()->add( 'iap_log', 'BuddyBossApp\InAppPurchases\Integration->rest_iap_product_response()' );
		}

		$found_product_ids = array();

		// NOTE : Defaults.
		$response = array(
			'integration_type'  => 'learndash-course',
			'bbapp_product_ids' => $found_product_ids,
			'purchase_item_id'  => $item_id,
			'purchase_require'  => false,
		);

		$default_args = array(
			'orderby' => 'id',
			'order'   => 'desc',
		);

		// LearnDash group now working when we pass integration type.
		$product_ids = Helpers::search_integration( $item_id, '', $default_args );
		$iap_ids     = Main::instance()->bbapp_get_course_cats_and_tags( $item_id );

		if ( ! empty( $iap_ids ) ) {
			$iap_pluck         = wp_list_pluck( $iap_ids, 'id' );
			$found_product_ids = array_map( 'intval', array_merge( $found_product_ids, $iap_pluck ) );
		}

		if ( ! empty( $product_ids ) ) {
			$product_ids       = wp_list_pluck( $product_ids, 'product_id' );
			$found_product_ids = array_merge( $found_product_ids, $product_ids );
		}

		foreach ( bbapp_iap_get_types() as $platform_type => $platform_label ) {
			$response[ strtolower( $platform_type ) ]['status'] = false;
		}

		$response['bbapp_product_ids'] = array_values( array_unique( $found_product_ids ) );

		if ( is_object( $rest_item ) ) {
			$rest_item->{$this->rest_response_product_property} = $response;
		} elseif ( is_array( $rest_item ) ) {
			$rest_item[ $this->rest_response_product_property ] = $response;
		}

		return $rest_item;
	}
}
