<?php
/**
 * Holds ajax related functionality for in-app purchases.
 *
 * @package BuddyBossApp\InAppPurchases
 */

namespace BuddyBossApp\InAppPurchases;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

use BuddyBossApp\Admin\InAppPurchases\Helpers;
use BuddyBossApp\Tools\Logger;
use WP_Error as WP_Error;

/**
 * Ajax class for in-app purchases.
 */
final class Ajax {

	/**
	 * Class instance.
	 *
	 * @var null $instance
	 */
	private static $instance = null;

	/**
	 * Ajax constructor.
	 */
	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * Get the instance of this class.
	 *
	 * @return Controller|null
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			$class_name     = __CLASS__;
			self::$instance = new $class_name();
			self::$instance->hooks();

		}

		return self::$instance;
	}

	/**
	 * Define all actions and filters here
	 */
	private function hooks() {
		add_action( 'wp_ajax_bbapp_iap_sync_store_product', array( $this, 'iap_sync_store_product' ) );
		// Run once a day to fetch the store products.
		add_action( 'bbapp_every_day', array( $this, 'bbapp_fetch_iap_store_products' ), 99 );
	}

	/***
	 * Fetch all products from apple and google store.
	 *
	 * @return bool|void
	 */
	public function bbapp_fetch_iap_store_products() {
		if ( ! bbapp_is_active( 'iap' ) ) {
			return;
		}
		$_GET['platform'] = 'all';
		$_GET['selected'] = '';
		$this->iap_sync_store_product();

		return true;
	}

	/**
	 * Sync Google/Apple Store product.
	 */
	public function iap_sync_store_product() {
		$stores_products = array();
		$platform        = ( ! empty( $_GET['platform'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['platform'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$sle_item        = ( ! empty( $_GET['selected'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['selected'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

		if ( ! empty( $platform ) && 'all' !== $platform ) {
			if ( ! empty( bbapp_iap()->iap[ $platform ] ) ) {
				$stores_products[ $platform ] = bbapp_iap()->iap[ $platform ]->sync_store_product();
			}
		} else {
			if ( ! empty( bbapp_iap()->iap ) ) {
				foreach ( bbapp_iap()->iap as $type => $device_platform ) {
					$stores_products[ $type ] = $device_platform->sync_store_product();
				}
			}
		}

		foreach ( $stores_products as $platform => $products ) {
			$html = '';
			ob_start();
			?>
			<option value="" data-product_type_label="" data-product_type_desc="" data-data-product_status_label="" data-data-product_status_desc=""><?php esc_html_e( '- Select Product -', 'buddyboss-app' ); ?></option>
			<?php foreach ( $products as $store_product ) { ?>
				<option value="<?php echo esc_attr( $store_product['id'] ); ?>"
						data-product_type="<?php echo esc_attr( $store_product['type'] ); ?>"
						data-product_type_label="<?php echo sprintf( '<b>%1$s </b>', esc_html__( 'Type:', 'buddyboss-app' ) ); ?><?php echo esc_attr( Helpers::get_store_product_info( $store_product['type'], $platform ) ); ?>"
						data-product_type_desc="<?php echo esc_attr( Helpers::get_store_product_info( $store_product['type'], $platform, 'description' ) ); ?>"
						data-product_status_label="<?php echo sprintf( '<b>%1$s </b>', esc_html__( 'Status:', 'buddyboss-app' ) ); ?><?php echo esc_attr( Helpers::get_store_product_status_info( $store_product['status'], $platform ) ); ?>"
						data-product_status_desc="<?php echo esc_attr( Helpers::get_store_product_status_info( $store_product['status'], $platform, 'description' ) ); ?>"
					<?php isset( $sle_item ) ? selected( $store_product['id'], $sle_item ) : ''; ?> >
					<?php echo esc_html( $store_product['name'] ); ?>
				</option>
				<?php
			}
			$html                        .= ob_get_clean();
			$stores_products[ $platform ] = $html;
		}

		wp_send_json_success( $stores_products );
	}
}
