<?php
/**
 * Drodpdown helper.
 *
 * @package BuddyBossApp\Helpers
 */

namespace BuddyBossApp\Helpers;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Class contains Select2 dropdown functions.
 *
 * @package BuddyBossApp\Helpers
 */
class Custom_Multiselect_Dropdown {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Array of dropdowns.
	 *
	 * @var $multiselect_dropdowns
	 */
	public $multiselect_dropdowns = array();

	/**
	 * Get the instance of the class.
	 *
	 * @since 1.5.2.1
	 * @return Custom_Multiselect_Dropdown
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->setup();
		}

		return self::$instance;
	}

	/**
	 * Setup method.
	 *
	 * @since 1.5.2.1
	 */
	public function setup() {
		add_action( 'wp_ajax_bbapp_dropdown_result', array( $this, 'results' ) );
		add_action( 'wp_ajax_noprev_bbapp_dropdown_result', array( $this, 'results' ) );
	}

	/**
	 * Register method.
	 *
	 * @param string $slug Name of select dropdown.
	 * @param array  $args Select dropdown arguments.
	 *
	 * @since 1.5.2.1
	 */
	public function register_results_callback( $slug, $args = array() ) {
		$defaults = array(
			'results_callback' => '',
		);

		$args = wp_parse_args( $args, $defaults );

		$this->multiselect_dropdowns[ $slug ] = $args;
	}

	/**
	 * Internal render Select dropdown.
	 *
	 * @param string $slug   select dropdpdown name.
	 * @param array  $args   Function arguments.
	 * @param array  $extras Extra data to send to dropdown.
	 *
	 * @since 1.5.2.1
	 */
	public function dropdown_render( $slug, $args, $extras = array() ) {

		$defaults = array(
			'field_name'               => $slug,
			'placeholder'              => __( 'Please select', 'buddyboss-app' ),
			'list_items'               => array(),
			'selected_items'           => array(),
			'disabled_items'           => array(),
			'add_button_label'         => __( 'Add new', 'buddyboss-app' ),
			'validation_error_message' => __( 'This field is required', 'buddyboss-app' ),
			'disable'                  => false,
			'button_disable'           => false,
			'option_disable'           => false,
			'disabled_options'         => array(),
			'class'                    => '',
			'type'                     => 'select',
		);

		$args = wp_parse_args( $args, $defaults );

		if ( 'select' === $args['type'] ) {
			$extras['type'] = 'select';
		}
		$args['selected_items'] = array_intersect( $args['selected_items'], array_keys( $args['list_items'] ) );
		$container_cls          = $args['class'];
		$html                   = '';
		$unique                 = 1;
		$container_cls         .= ( 'select2' === $args['type'] ) ? ' bb-select2-cmn' : '';
		ob_start();
		?>
		<div class="bb-select-main-wrapper">
			<div class="bb-select-inr-wrapper">
				<?php
				if ( ! empty( $args['selected_items'] ) ) {
					foreach ( $args['selected_items'] as $index => $selected_item ) {
						$args = $this->get_args( $args, $selected_item );
						?>
						<div class="bb-select-cmn">
							<?php if ( 1 < count( $args['selected_items'] ) ) { ?>
								<a href="javascript:void(0);" class="bb-remove-clone">
									<i class="dashicons dashicons-no-alt"></i>
								</a>
							<?php } ?>
							<select id="bb-select-<?php echo esc_attr( $unique ); ?>"
									name="<?php echo esc_attr( $args['field_name'] ) . '[]'; ?>"
									data-slug="<?php echo esc_attr( $slug ); ?>"
									class="bb-select <?php echo esc_attr( $container_cls ); ?>" <?php disabled( $args['disable'], true ); ?>
									data-err-msg="<?php echo esc_attr( $args['validation_error_message'] ); ?>"
									data-option-disable="<?php echo esc_attr( $args['option_disable'] ); ?>"
									data-disabled-options="<?php echo esc_attr( wp_json_encode( $args['disabled_options'] ) ); ?>"
									data-select-key="<?php echo esc_attr( $unique ); ?>"
									data-extras="<?php echo esc_attr( wp_json_encode( $extras ) ); ?>">
								<?php
								echo sprintf( "<option value='0' %s>%s</option>", selected( $selected_item, 0, false ), esc_html( $args['placeholder'] ) );
								if ( ! empty( $args['list_items'] ) ) {
									foreach ( $args['list_items'] as $key => $list_item ) {
										$list_item = strlen( $list_item ) > 50 ? substr( $list_item, 0, 50 ) . '...' : $list_item;
										if ( true === $args['option_disable'] && ! empty( $args['disabled_options'] ) && in_array( $key, $args['disabled_options'] ) ) { //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
											echo sprintf( "<option value='%s' disabled %s>%s</option>", esc_attr( $key ), selected( $selected_item, $key, false ), esc_html( $list_item ) );
										} else {
											echo sprintf( "<option value='%s' data-disabled='%s' %s>%s</option>", esc_attr( $key ), esc_attr( in_array( $key, $args['disabled_items'] ) ), selected( $selected_item, $key, false ), esc_html( $list_item ) ); //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
										}
									}
								}
								?>
							</select>
						</div>
						<?php
						$unique ++;
					}
				} else {
					?>
					<div class="bb-select-cmn">
						<select id="bb-select-<?php echo esc_attr( $unique ); ?>"
								name="<?php echo esc_attr( $args['field_name'] ) . '[]'; ?>"
								data-slug="<?php echo esc_attr( $slug ); ?>"
								class="bb-select <?php echo esc_attr( $container_cls ); ?>" <?php disabled( $args['disable'], true ); ?>
								data-err-msg="<?php echo esc_attr( $args['validation_error_message'] ); ?>"
								data-option-disable="<?php echo esc_attr( $args['option_disable'] ); ?>"
								data-disabled-options="<?php echo esc_attr( wp_json_encode( $args['disabled_options'] ) ); ?>"
								data-select-key="<?php echo esc_attr( $unique ); ?>"
								data-extras="<?php echo esc_attr( wp_json_encode( $extras ) ); ?>">
							<?php
							echo sprintf( "<option value='0' selected>%s</option>", esc_html( $args['placeholder'] ) );
							if ( ! empty( $args['list_items'] ) ) {
								foreach ( $args['list_items'] as $key => $list_item ) {
									$args      = $this->get_args( $args, $list_item );
									$list_item = strlen( $list_item ) > 50 ? substr( $list_item, 0, 50 ) . '...' : $list_item;
									if ( true === $args['option_disable'] && ! empty( $args['disabled_options'] ) && in_array( $key, $args['disabled_options'] ) ) { //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
										echo sprintf( "<option value='%s' disabled>%s</option>", esc_attr( $key ), esc_html( $list_item ) );
									} else {
										echo sprintf( "<option value='%s'>%s</option>", esc_attr( $key ), esc_html( $list_item ) );
									}
								}
							}
							?>
						</select>
					</div>
					<?php
				}
				?>
			</div>
			<button type="button" <?php disabled( $args['button_disable'], true ); ?> class="button bb-add-dropdown">
				<?php echo sprintf( '+ %s', esc_html( $args['add_button_label'] ) ); ?>
			</button>
		</div>
		<?php
		$this->select2_script();
		$html .= ob_get_clean();

		$allowed_html                 = wp_kses_allowed_html( 'post' );
		$allowed_html['a']['onclick'] = true;
		$allowed_html['textarea']     = array(
			'cols'         => true,
			'rows'         => true,
			'disabled'     => true,
			'name'         => true,
			'readonly'     => true,
			'id'           => true,
			'class'        => true,
			'data-err-msg' => true,
		);
		$allowed_html['script']       = array();
		$allowed_html['select']       = array(
			'id'                    => true,
			'class'                 => true,
			'name'                  => true,
			'data-nonce'            => true,
			'disabled'              => true,
			'data-slug'             => true,
			'data-err-msg'          => true,
			'data-option-disable'   => true,
			'data-disabled-options' => true,
			'data-select-key'       => true,
			'data-extras'           => true,
		);
		$allowed_html['option']       = array(
			'value'    => true,
			'selected' => true,
			'disabled' => true,
		);
		$allowed_html['input']        = array(
			'id'           => true,
			'class'        => true,
			'name'         => true,
			'type'         => true,
			'checked'      => true,
			'value'        => true,
			'data-err-msg' => true,
		);
		echo wp_kses( $html, $allowed_html, array( 'javascript' ) );
	}

	/**
	 * Select2 dropdown html render method.
	 *
	 * @param string $slug   Select dropdown name.
	 * @param array  $args   Arguments for select dropdown.
	 * @param array  $extras Extra arguments.
	 *
	 * @since 1.5.2.1
	 */
	public function render( $slug, $args, $extras = array() ) {
		$this->dropdown_render( $slug, $args, $extras );
	}

	/**
	 * This function run the result callback function.
	 *
	 * @return array|false|mixed
	 *
	 * @since 1.5.2.1
	 */
	public function results() {
		$slug   = ( ! empty( $_POST['slug'] ) ) ? bbapp_input_clean( wp_unslash( $_POST['slug'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$page   = ( ! empty( $_POST['page'] ) ) ? absint( $_POST['page'] ) : 1; //phpcs:ignore WordPress.Security.NonceVerification.Missing
		$limit  = ( ! empty( $_POST['per_page'] ) ) ? absint( $_POST['per_page'] ) : 20; //phpcs:ignore WordPress.Security.NonceVerification.Missing
		$search = ! empty( $_POST['term']['term'] ) ? bbapp_input_clean( wp_unslash( $_POST['term']['term'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$extras = ( ! empty( $_POST['extras'] ) ) ? wp_unslash( $_POST['extras'] ) : array(); //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

		return ( is_callable( $this->multiselect_dropdowns[ $slug ]['results_callback'] ) ) ? call_user_func_array(
			$this->multiselect_dropdowns[ $slug ]['results_callback'],
			array(
				$search,
				$page,
				$limit,
				$extras,
			)
		) : array();
	}


	/**
	 * Function to load the select2 script on admin footer if used on any backend page.
	 *
	 * @since 1.5.2.1
	 */
	public function select2_script() {
		?>
		<script>
            jQuery( document ).ready( function() {
                /**
                 * Run the menu access control select.
                 */
                jQuery( document ).bind( 'bbapp_dropdown_after_clone', function() {
                    if ( 2 === jQuery( '.bb-select-cmn' ).length ) {
                        jQuery( '.bb-select-cmn:first' ).prepend( '<a href="javascript:void(0);" class="bb-remove-clone"><i class="dashicons dashicons-no-alt"></i></a>' );
                    }
                } );

                /**
                 * Run the menu access control select.
                 */
                jQuery( document ).bind( 'bbapp_dropdown_after_remove_clone', function() {
                    if ( 1 === jQuery( '.bb-remove-clone' ).length ) {
                        jQuery( '.bb-remove-clone' ).remove();
                    }
                } );

                initializeSelect2Dropdown( 'bb-select2-cmn' );

                /** * Add dropdown box.
                 */
                jQuery( '.bb-add-dropdown' ).click( function() {
                    const select2El = jQuery( '.bb-select2-cmn' );

                    select2El.select2( 'destroy' );

                    const curObj = jQuery( this );
                    const mainWrp = curObj.parent().find( '.bb-select-inr-wrapper' );
                    const firstCmn = jQuery( '.bb-select-cmn', mainWrp ).first();
                    const lastCmn = jQuery( '.bb-select-cmn', mainWrp ).last();
                    const cloneCmn = firstCmn.clone( true );

                    mainWrp.append( cloneCmn );

                    const lastCloned = jQuery( '.bb-select-cmn', mainWrp ).last();
                    const lastClonedId = parseInt( lastCmn.find( 'select' ).attr( 'data-select-key' ) ) + ( 1 );

                    lastCloned.find( 'select' ).attr( 'data-select-key', lastClonedId );
                    lastCloned.find( 'select' ).attr( 'id', 'bb-select-' + lastClonedId );
                    lastCloned.find( 'select' ).attr( 'data-select2-id', 'bb-select-' + lastClonedId );
                    lastCloned.find( 'select' ).removeClass( 'bbapp-has-err' );
                    lastCloned.find( 'select' ).prop( 'disabled', false );
                    lastCloned.find( '.bbapp-field-err-cmn' ).remove();

                    if ( 0 === lastCloned.find( '.bb-remove-clone' ).length ) {
                        lastCloned.prepend( '<a href="javascript:void(0);" class="bb-remove-clone"><i class="dashicons dashicons-no-alt"></i></a>' );}


                    initializeSelect2Dropdown( 'bb-select2-cmn' );
                    jQuery( '.bb-select2-cmn' ).last().val( [ '0' ] ).trigger( 'change' );

                    lastCloned.find( 'select option' ).each( function( i, obj ) {
                        if ( '0' === jQuery( obj ).val() ) {
                            jQuery( obj ).prop( 'selected', true );
                        }

                        if ( '1' === jQuery( obj ).attr( 'data-disabled' ) ) {
                            jQuery( obj ).prop( 'disabled', true );
                        }

                        jQuery( obj ).removeAttr( 'data-disabled' );
                    } );

                    /** * When add new dropdown run the trigger.
                     */
                    jQuery( document ).trigger( 'bbapp_dropdown_after_clone' );
                } );

                /**
                 * Remove dropdown box.
                 */
                jQuery( document ).on( 'click', '.bb-remove-clone', function () {
                    jQuery( this ).parent().remove();

                    /**
                     * When clone remove the trigger will be call.
                     */
                    jQuery( document ).trigger( 'bbapp_dropdown_after_remove_clone' );
                } );
            } );

            /**
             * Initialize the select2 dropdown.
             *
             * @param {string} selectorClass Selector class name.
             */
            function initializeSelect2Dropdown( selectorClass ) {
                jQuery( '.' + selectorClass ).each( function() {
                    const id = jQuery( this ).attr( 'id' );
                    const name = jQuery( this ).attr( 'name' ).replace( '[]', '' );
                    const extras = jQuery.parseJSON( jQuery( this ).attr( 'data-extras' ) );

                    const ajaxData = {
                        url: bbappAjax.ajaxurl,
                        dataType: 'json',
                        type: 'POST',
                        // eslint-disable-next-line no-unused-vars
                        data( term, page ) {
                            return {
                                action: 'bbapp_dropdown_result',
                                term,
                                slug: name,
                                extras,
                            };
                        },
                        // eslint-disable-next-line no-unused-vars
                        processResults( data, params ) {
                            return {
                                results: data.items,
                            };
                        },
                    };

                    const select2Data = {
                        multiple: false,
                    };

                    if ( false !== extras.ajax ) {
                        select2Data.ajax = ajaxData;
                    }

                    jQuery( '#' + id ).select2( select2Data );
                } );
            }
        </script>
		<?php
	}

	/**
	 * Function to get Argument.
	 *
	 * @param array      $args      Dropdown arguments.
	 * @param int|string $list_item List item.
	 *
	 * @since 1.5.2.1
	 * @return mixed
	 */
	public function get_args( $args, $list_item ) {
		if ( ! empty( $args['disabled_items'] ) && in_array( $list_item, $args['disabled_items'] ) ) { //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
			$args['disable']          = true;
			$args['option_disable']   = false;
			$args['disabled_options'] = array();
		} else {
			$args['disable']          = false;
			$args['option_disable']   = true;
			$args['disabled_options'] = $args['disabled_items'];
		}

		return $args;
	}
}
