<?php
/**
 * Holds BuddyBoss App plugin upgrade functionality.
 *
 * @package BuddyBossApp\Helpers
 */

namespace BuddyBossApp\Helpers;

if ( ! class_exists( 'BuddyBossApp_Plugin_Upgrader_Skin' ) ) {

	include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';

	/**
	 * BuddyBoss App Plugin update class.
	 */
	class BuddyBossApp_Plugin_Upgrader_Skin extends \WP_Upgrader_Skin {

		/**
		 * BuddyBossApp_Plugin_Upgrader_Skin constructor.
		 *
		 * @param array $args Class arguments.
		 */
		public function __construct( $args = array() ) {
			$defaults   = array(
				'type'   => 'web',
				'url'    => '',
				'plugin' => '',
				'nonce'  => '',
				'title'  => '',
			);
			$args       = wp_parse_args( $args, $defaults );
			$this->type = $args['type'];
			$this->api  = isset( $args['api'] ) ? $args['api'] : array();

			parent::__construct( $args );
		}

		/**
		 * Request file system details.
		 *
		 * @param bool $error                        Is error.
		 * @param bool $context                      Context.
		 * @param bool $allow_relaxed_file_ownership Is file relaxed ownership.
		 *
		 * @return bool
		 */
		public function request_filesystem_credentials( $error = false, $context = false, $allow_relaxed_file_ownership = false ) {
			return true;
		}

		/**
		 * Error.
		 *
		 * @param array $errors Error messages.
		 */
		public function error( $errors ) {
			die( '-1' );
		}

		/**
		 * File header.
		 */
		public function header() {
		}

		/**
		 * File footer
		 */
		public function footer() {
		}

		/**
		 * Feedback.
		 *
		 * @param string $string Feedback message.
		 */
		public function feedback( $string ) {
		}
	}
}
