<?php
/**
 * Holds deeplinking functionalty related term.
 *
 * @package BuddyBossApp\DeepLinking\Type
 */

namespace BuddyBossApp\DeepLinking\Type;

/**
 * Deeplink class for Terms.
 */
class TermType extends TypeAbstract {

	/**
	 * Parse Term urls.
	 *
	 * @param string $url URL to parse.
	 *
	 * @return mixed|null
	 */
	public function parse( $url ) {
		$url_meta = $this->get_url_data( $url );
		foreach ( get_taxonomies( array(), 'objects' ) as $taxonomy => $t ) {
			if ( $t->query_var && isset( $url_meta[ $t->query_var ] ) ) {
				$term = get_term_by( 'slug', $url_meta[ $t->query_var ], $t->name );

				if ( empty( $term ) ) {
					continue;
				}

				/**
				 * Filter terms deep linking namespace
				 */
				$namespace = apply_filters( 'bbapp_deeplinking_term_namespace', 'core', $term );

				$response = array(
					'action'       => 'open_term',
					'namespace'    => $namespace,
					'url'          => $url,
					'term_id'      => $term->term_id,
					'taxonomy'     => $term->taxonomy,
					'name'         => $term->name,
				);

				if ( ! empty( $url_meta['year'] ) ) {
					$response['year'] = $url_meta['year'];
				}

				if ( ! empty( $url_meta['monthnum'] ) ) {
					$response['monthnum'] = $url_meta['monthnum'];
				}

				if ( ! empty( $url_meta['day'] ) ) {
					$response['day'] = $url_meta['day'];
				}

				/**
				 * Filter terms deep linking data
				 */
				return apply_filters( 'bbapp_deeplinking_term', $response, $term );
			}
		}

		return null;
	}
}
