<?php
/**
 * Holds custom post type deeplinking functoinality
 *
 * @package BuddyBossApp\DeepLinking\Type
 */

namespace BuddyBossApp\DeepLinking\Type;

/**
 * Custom post type class.
 */
class CptType extends TypeAbstract {

	/**
	 * Parse custom post type urls
	 *
	 * @param string $url URL to parse.
	 *
	 * @return array|null
	 */
	public function parse( $url ) {
		global $wp;
		$wp->add_query_var( 'app_page' );
		$url_id = url_to_postid( $url );

		if ( defined( 'BP_PLATFORM_VERSION' ) ) {
			/**
			 * Check is platform page.
			 */
			$bp = buddypress();
			// Fetch all the WP page names for each component.
			if ( empty( $bp->pages ) ) {
				$bp->pages = bp_core_get_directory_pages();
			}

			/**
			 * Filters the BuddyPress global pages
			 *
			 * - This filter is documented in bp-core/bp-core-filters.php
			 *
			 * @param object
			 *
			 * @since 1.5.7
			 */
			$bp->pages = apply_filters( 'bp_pages', $bp->pages );
			foreach ( (array) $bp->pages as $page_key => $bp_page ) {
				if ( (int) $bp_page->id === (int) $url_id ) {
					return null;
				}
			}
		}

		if ( ! empty( $url_id ) ) {
			$post      = get_post( $url_id );
			$post_type = $post->post_type;

			/**
			 * Filter cpt deep linking action
			 */
			$action = apply_filters( 'bbapp_deeplinking_cpt_action', "open_{$post_type}", $post );

			/**
			 * Filter cpt deep linking namespace
			 */
			$namespace = apply_filters( 'bbapp_deeplinking_cpt_namespace', 'core', $post_type );

			$deep_link_data = array(
				'action'       => $action,
				'namespace'    => $namespace,
				'url'          => $url,
				'item_id'      => $post->ID,
				'_link_action' => 'core_' . $post_type . 's',
			);

			/**
			 * Filter CPT deep linking data (deprecated) - use bbapp_deeplinking_cpt_type instead of this.
			 *
			 * @param array    $deep_link_data The post data.
			 * @param \WP_Post $post           Post object.
			 * @param string   $url            The requested URL.
			 */
			$deep_link_data = apply_filters_deprecated(
				'bbapp_deeplinking_cpt',
				array(
					$deep_link_data,
					$post,
					$url,
				),
				'1.8.10',
				'bbapp_deeplinking_cpt_type'
			);

			/**
			 * Filter CPT deep linking data (deprecated) - use bbapp_deeplinking_cpt_type instead of this.
			 *
			 * @param array    $deep_link_data The post data.
			 * @param \WP_Post $post           Post object.
			 * @param string   $url            The requested URL.
			 *
			 * @since            1.8.30 Added the `$url ` parameter.
			 *
			 * @return array
			 *
			 * @deprecated       1.8.10
			 *                   Use bbapp_deeplinking_cpt_type instead of this.
			 */
			return apply_filters( 'bbapp_deeplinking_cpt_type', $deep_link_data, $post, $url );
		}

		$url_meta = $this->get_url_data( $url );
		if ( isset( $url_meta['post_type'] ) ) {

			/**
			 * Filter cpt deep linking namespace
			 */
			$namespace = apply_filters( 'bbapp_deeplinking_cpt_namespace', 'core', $url_meta['post_type'] );

			return array(
				'action'    => 'open_archive',
				'namespace' => $namespace,
				'url'       => $url,
				'post_type' => $url_meta['post_type'],
			);
		}

		return null;

	}

}
