<?php
/**
 * Holds deeplinking functionalty related author type.
 *
 * @package BuddyBossApp\DeepLinking\Type
 */

namespace BuddyBossApp\DeepLinking\Type;

/**
 * Author type class for the different types of author.
 */
class AuthorType extends TypeAbstract {

	/**
	 * Parse author url
	 *
	 * @param string $url Deeplink url.
	 *
	 * @return mixed|null
	 */
	public function parse( $url ) {
		$url_meta = $this->get_url_data( $url );
		if ( isset( $url_meta['author_name'] ) ) {
			$user = get_user_by( 'login', $url_meta['author_name'] );
			if ( ! empty( $user ) ) {

				/**
				 * Filter Author deep linking data
				 */
				return apply_filters(
					'bbapp_deeplinking_author',
					array(
						'action'       => 'open_user',
						'namespace'    => 'core',
						'url'          => $url,
						'item_id'      => $user->ID,
						'_link_action' => 'wp_user',
					),
					$user
				);
			}
		}

		return null;
	}
}
