<?php
/**
 * DeepLinking Screens.
 *
 * @package BuddyBossApp\DeepLinking\Type
 */

namespace BuddyBossApp\DeepLinking\Type;

/**
 * Class app page type.
 */
class AppPageType extends TypeAbstract {

	/**
	 * AppPageType constructor.
	 */
	public function __construct() {
		parent::__construct();
		add_filter( 'bbapp_deeplinking_cpt_type', array( $this, 'update_cpt_object' ), 10, 3 );
	}

	/**
	 * Add item embed with response
	 *
	 * @param array    $response The response data to send to the client.
	 * @param \WP_Post $post     The post object.
	 * @param string   $url      The requested URL.
	 *
	 * @since 1.8.30 Added the `$url ` parameter.
	 *
	 * @return mixed
	 */
	public function update_cpt_object( $response, $post, $url ) {

		if ( 'app_page' === $post->post_type ) {
			$response['_link_action'] = 'app_page';
		}

		return $response;
	}

	/**
	 * Parse deeplink url data.
	 *
	 * @param string $url Deeplink url.
	 */
	public function parse( $url ) {
	}
}
