<?php
/**
 * Holds DB update functionality.
 *
 * @package BuddyBossApp\DBUpdate
 */

namespace BuddyBossApp\DBUpdate;

use BuddyBossApp\AppLanguages;
use BuddyBossApp\InAppPurchases\Orders;
use BuddyBossApp\Tools\Logger\BgProcessLog;

/**
 * Db Update class
 */
class Main {

	/**
	 * Class instance.
	 *
	 * @var Main|null
	 */
	private static $instance;

	/**
	 * Custom migration run.
	 *
	 * @var bool
	 */
	private $custom_migration_run = false;

	/**
	 * Function construct method.
	 */
	public function __construct() {
	}

	/**
	 * Class instance method.
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Load method.
	 */
	public function load() {
		$this->custom_migration_run = ! empty( $_GET['bbapp_custom_migration_run'] ) ? sanitize_text_field( wp_unslash( $_GET['bbapp_custom_migration_run'] ) ) : false; // phpcs:ignore

		// Database version for migration.
		$current_db_version = get_option( 'bbapp_db_version' );

		if ( 4 > $current_db_version ) {
			Versions::instance()->update_4();
		}
		if ( 5 > $current_db_version ) {
			Versions::instance()->update_5();
		}

		if ( 6 > $current_db_version ) {
			Versions::instance()->update_6();
		}

		if ( 7 > $current_db_version ) {
			Versions::instance()->update_7();
		}

		if ( 8 > $current_db_version ) {
			bbapp()->on_database_update( bbapp()->is_network_activated() );
			Versions::instance()->update_8();
		}

		if ( 9 > $current_db_version ) {
			Versions::instance()->update_9();
		}

		if ( 10 > $current_db_version ) {
			// Update devices table.
			bbapp()->on_database_update( bbapp()->is_network_activated() );
		}

		// Update database for v1.4.2.
		if ( 11 > $current_db_version ) {
			Versions::instance()->update_11();
		}

		// Update database for v1.4.3.
		if ( 12 > $current_db_version ) {
			Versions::instance()->update_12();
		}

		// Update database for v1.4.4.
		if ( 13 > $current_db_version ) {
			Versions::instance()->update_13();
		}

		// Update database for v1.4.5.
		if ( 14 > $current_db_version ) {
			Versions::instance()->update_14();
		}

		// Update database for v1.4.8.
		if ( 15 > $current_db_version ) {
			Versions::instance()->update_15();
		}

		/**
		 * Todo: function is temp because current task is not in current sprint.
		 */
		if ( 16 > $current_db_version ) {
			Versions::instance()->update_16();
		}

		if ( 17 > $current_db_version ) {
			Versions::instance()->update_17();
		}

		if ( 18 > $current_db_version ) {
			Versions::instance()->update_18();
		}

		if ( 19 > $current_db_version ) {
			Versions::instance()->update_19();
		}

		if ( 20 > $current_db_version ) {
			Versions::instance()->update_20();
		}

		if ( 21 > $current_db_version ) {
			Versions::instance()->update_21();
		}

		if ( 26 > $current_db_version ) {
			Versions::instance()->update_26();
		}

		if ( 29 > $current_db_version ) {
			Versions::instance()->update_29();
		}

		if ( 28 > $current_db_version ) {
			// Delete bbapp_push_notifications_meta table.
			Versions::instance()->update_22();
			// Update devices table.
			bbapp()->on_database_update( bbapp()->is_network_activated() );
		}

		if ( bbapp()->db_version > $current_db_version ) {
			// Update devices table.
			bbapp()->on_database_update( bbapp()->is_network_activated() );
		}

		if ( (int) bbapp()->db_version !== (int) $current_db_version || $this->custom_migration_run ) {
			// @todo - Write only data manipulate migration here. ( This is not for DB structure change ).
			Versions::instance()->update_23();
			Versions::instance()->update_24();
			BgProcessLog::instance()->create_table();
			Versions::instance()->update_27();
			Versions::instance()->update_28();
			Versions::instance()->update_30();
			Versions::instance()->update_31();
			Versions::instance()->update_32();
			Versions::instance()->update_32_1();
		}

		// Store history when plugin update.
		$this->bbapp_plugin_update();

		add_action( 'bbapp_queue_task_rm_dup_iap_orders_13', array( $this, 'rm_dup_iap_orders_13_bg_job' ) ); // Background Job.
		add_action( 'bbapp_queue_task_rm_dup_devices_24', array( $this, 'rm_dup_devices_24_bg_job' ) ); // Background Job.
	}

	/**
	 * Update plugin version history in the database.
	 *
	 * @since 1.8.40
	 * @return void
	 */
	public function bbapp_plugin_update() {
		// Current DB version of this site (per site in a multisite network).
		$current_db   = get_option( 'bbapp_db_version' );
		$current_live = bbapp()->db_version;

		$bbapp_plugin_version_history = (array) get_option( 'bb_app_plugin_version_history', array() );
		$initial_version_data         = ! empty( $bbapp_plugin_version_history ) ? end( $bbapp_plugin_version_history ) : array();
		$bbapp_version_exists         = ! empty( $initial_version_data ) && ! empty( $initial_version_data['version'] ) && (string) bbapp()->plugin_version === (string) $initial_version_data['version'];
		if ( ! $bbapp_version_exists || $current_live !== $current_db ) {
			$current_date                   = new \DateTime( 'now', new \DateTimeZone( 'UTC' ) );
			$bbapp_latest_plugin_version    = array(
				'db_version' => $current_live,
				'date'       => $current_date->format( 'Y-m-d H:i:s' ),
				'version'    => bbapp()->plugin_version,
			);
			$bbapp_plugin_version_history[] = $bbapp_latest_plugin_version;

			update_option( 'bb_app_plugin_version_history', array_filter( $bbapp_plugin_version_history ) );
		}
	}

	/**
	 * Find all duplicate In-app purchase orders in the database and change the status to failed.
	 *
	 * @param object $task IAP update background job.
	 *
	 * @since 1.4.4
	 */
	public function rm_dup_iap_orders_13_bg_job( $task ) {
		$order_chunks_items = maybe_unserialize( $task->data );
		global $wpdb;

		$table_name = bbapp_get_network_table( 'bbapp_iap_orders' );
		foreach ( $order_chunks_items as $order ) {
			$correct_orders = get_option( 'bbapp_correct_orders_13', array() );

			// Find correct get result.
			$get_results = $wpdb->get_col( $wpdb->prepare( "SELECT id FROM {$table_name} WHERE `order_status` = %s AND `bbapp_product_id` = %s AND `user_id` = %s AND `id` != %s ORDER BY `date_created` ASC", array( $order->order_status, $order->bbapp_product_id, $order->user_id, $order->id ) ) ); //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared

			if ( ! empty( $get_results ) ) {
				foreach ( $get_results as $order_id ) {
					if ( in_array( $order_id, $correct_orders, true ) ) {
						continue;
					}

					$updated = $wpdb->query( $wpdb->prepare( "UPDATE {$table_name} SET `order_status` = 'failed' WHERE `order_status` = %s AND `bbapp_product_id` = %s AND `user_id` = %s AND `id` = %s ORDER BY `date_created` ASC", array( $order->order_status, $order->bbapp_product_id, $order->user_id, $order_id ) ) ); //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared

					if ( $updated ) {
						$correct_orders[] = $order->id;
					}
					Orders::instance()->add_history( $order_id, 'info', __( 'Order marked as failed due to duplicate entries.', 'buddyboss-app' ) );
				}

				$correct_orders = array_unique( $correct_orders );
				update_option( 'bbapp_correct_orders_13', $correct_orders, false );
			}
		}
	}

	/**
	 * Removed the duplicate device data.
	 *
	 * @param object $task Job data.
	 *
	 * @since 2.0.51
	 *
	 * @return void
	 */
	public function rm_dup_devices_24_bg_job( $task ) {
		global $wpdb;

		$table_name      = bbapp_get_network_table( 'bbapp_user_devices' );
		$chunked_devices = maybe_unserialize( $task->data );

		foreach ( $chunked_devices as $chunked_device ) {
			$user_devices = $wpdb->get_results( $wpdb->prepare( "SELECT id FROM {$table_name} WHERE user_id=%d AND device_id=%s ORDER BY date_active DESC", $chunked_device->user_id, $chunked_device->device_id ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared

			if ( empty( $user_devices ) ) {
				return;
			}

			$user_devices = wp_list_pluck( $user_devices, 'id' );

			array_shift( $user_devices );

			$seperated_ids = "'" . implode( "','", $user_devices ) . "'";

			$wpdb->query( "DELETE FROM {$table_name} WHERE id IN ($seperated_ids)" ); //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		}
	}
}
