<?php
/**
 * Holds Notifications components functionality.
 *
 * @package BuddyBossApp\Components\PushNotification
 */

namespace BuddyBossApp\Components\PushNotification;

use BuddyBossApp\Api\Notification\Main;
use BuddyBossApp\Components;
use BuddyBossApp\Integrations\CoreIntegration;
use BuddyBossApp\Notification\Actions;
use BuddyBossApp\Notification\Notification;
use BuddyBossApp\Notification\Push;
use BuddyBossApp\Notification\RestAPI;
use BuddyBossApp\Notification\RestAPIv2;
use BuddyBossApp\Notification\UserProfile;
use BuddyBossApp\Permissions;
use BuddyBossApp\UserSegment;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * This class is used to add the components into BuddyBossApp.
 * Class Extend
 *
 * @package BuddyBossApp\Notification
 */
final class PushNotification extends Components\Extend {

	/**
	 * Construct function for the class.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * Load function.
	 *
	 * @return void
	 */
	public function load() {
		$this->start(
			'push_notification',
			__( 'Push Notifications', 'buddyboss-app' ),
			__( "Send automated and manual push notifications directly to your member's devices.", 'buddyboss-app' ),
			false,
			false
		);
	}

	/**
	 * Provide setting links by components.
	 *
	 * @return mixed
	 */
	public function settings_links() {

		$links = array();

		if ( Permissions::instance()->can_manage_app() ) {
			$links['settings'] = array(
				'label' => __( 'Settings', 'buddyboss-app' ),
				'link'  => bbapp_get_super_admin_url( 'admin.php?page=bbapp-settings&setting=push_notifications' ),
			);
		}

		return $links;

	}

	/**
	 * Safe point to load all codes.
	 *
	 * @return mixed
	 */
	public function components_loaded() {

		if ( bbapp_is_active( 'push_notification' ) ) {
			// User Segments.
			UserSegment::instance();
			Push::instance();
			CoreIntegration::instance();
			Main::instance();
			Actions::instance();

			add_action( 'init', array( $this, 'load_notification_on_init' ), 9 );
			add_action( 'init', array( $this, 'load_on_init' ) );
		}
	}

	/**
	 * Code to load on init hook.
	 */
	public function load_on_init() {

	}

	/**
	 * Load notification on init.
	 *
	 * @since 1.4.7
	 */
	public function load_notification_on_init() {
		Notification::instance();
	}
}
