<?php

namespace BuddyBossApp\Components\Performance;

use BuddyBossApp\Components;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * This class is used to add the components into BuddyBossApp.
 * Class Extend
 * @package BuddyBossApp\Performance
 */
final class Performance extends Components\Extend {

	function __construct() {
		/** Nothing here */
	}

	function load() {
		$this->start( "performance",
			__( "API Performance", "buddyboss-app" ),
			__( "Allow API data to be cached, and API media to load from a CDN, to improve performance.", "buddyboss-app" ),
			true,
			false );
	}

	/**
	 * Provide setting links by components.
	 *
	 * @return mixed
	 */
	function settings_links( ) {

		$links = array();

		$links["settings"] = array(
			"label" => __( "Settings", "buddyboss-app" ),
			"link"  => bbapp_get_super_admin_url( "admin.php?page=bbapp-settings&setting=cache_support" )
		);

		return $links;
	}

	/**
	 * Safe point to load all codes.
	 * @return mixed
	 */
	public function components_loaded() {
		if ( bbapp_is_active( 'performance' ) ) {
			require_once trailingslashit( bbapp()->plugin_dir ) . 'include/Performance/class-performance.php';

			// Include and validate the performance.
			if ( class_exists( 'BuddyBoss\Performance\Performance' ) ) {
				\BuddyBoss\Performance\Performance::instance()->validate();
			}
		}
	}
}