<?php
/**
 * In-App purchase component register class
 *
 * @package @package BuddyBossApp\InAppPurchases
 */

namespace BuddyBossApp\Components\InAppPurchases;

use BuddyBossApp\Components;
use BuddyBossApp\InAppPurchases\Controller;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * This class is used to add the components into BuddyBossApp.
 * Class Extend
 *
 * @package BuddyBossApp\InAppPurchases
 */
final class InAppPurchases extends Components\Extend {

	/**
	 * InAppPurchases constructor.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * Load method.
	 *
	 * @return void
	 */
	public function load() {
		$this->start(
			'iap',
			__( 'In-App Purchases', 'buddyboss-app' ),
			__( 'Allow members to purchase products in your app, through the Apple App Store and Google Play Store.', 'buddyboss-app' ),
			false,
			false
		);
	}

	/**
	 * Provide setting links by components.
	 *
	 * @return mixed
	 */
	public function settings_links() {

		$links = array();

		$links['settings'] = array(
			'label' => __( 'Settings', 'buddyboss-app' ),
			'link'  => bbapp_get_super_admin_url( 'admin.php?page=bbapp-settings&setting=inapp_purchases' ),
		);

		return $links;
	}

	/**
	 * Safe point to load all codes.
	 *
	 * @return mixed
	 */
	public function components_loaded() {

		if ( bbapp_is_active( 'iap' ) ) {
			// InAppPurchases Controller.
			Controller::instance();
		}
	}
}
