<?php
/**
 * Holds Native App Pages component functionality.
 *
 * @package BuddyBossApp\Components\AppPages
 */

namespace BuddyBossApp\Components\AppPages;

use BuddyBossApp\Components;
use BuddyBossApp\NativeAppPage;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * This class is used to add the components into BuddyBossApp.
 * Class Extend
 *
 * @package BuddyBossApp\AppPages
 */
final class AppPages extends Components\Extend {

	/**
	 * AppPages constructor.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * Load component.
	 */
	public function load() {
		$this->start(
			'app_pages',
			__( 'App Pages', 'buddyboss-app' ),
			__( 'Create content to be displayed only in your app, but not on your website.', 'buddyboss-app' ),
			true,
			true
		);
	}

	/**
	 * Provide setting links by components.
	 *
	 * @return mixed
	 */
	public function settings_links() {
		$links             = array();
		$links['settings'] = array(
			'label' => __( 'Edit Pages', 'buddyboss-app' ),
			'link'  => bbapp_get_admin_url( 'edit.php?post_type=app_page' ),
		);

		return $links;
	}

	/**
	 * Safe point to load all codes.
	 *
	 * @return mixed|void
	 */
	public function components_loaded() {
		NativeAppPage::instance();
	}
}
