<?php
/**
 * Holds Access Controls registering functionality.
 *
 * @package BuddyBossApp\Components\AccessControls
 */

namespace BuddyBossApp\Components\AccessControls;

use BuddyBossApp\Components;
use BuddyBossApp\Permissions;
use BuddyBossApp\Admin\AccessControls\UserProfile;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * This class is used to add the components into BuddyBossApp.
 * Class Extend
 *
 * @package BuddyBossApp\AccessControls
 */
final class AccessControls extends Components\Extend {

	/**
	 * Construct method.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * Load function
	 *
	 * @since 1.5.2.1
	 */
	public function load() {
		$this->start( 'access_controls', __( 'Access Controls', 'buddyboss-app' ), __( 'Limit access to content in your app to specific groups of members.', 'buddyboss-app' ), true );
	}


	/**
	 * Provide setting links by components.
	 *
	 * @since 1.5.2.1
	 *
	 * @return mixed
	 */
	public function settings_links() {
		$links = array();

		if ( Permissions::instance()->can_manage_app() ) {
			$links['settings'] = array(
				'label' => __( 'Settings', 'buddyboss-app' ),
				'link'  => bbapp_get_super_admin_url( 'admin.php?page=bbapp-settings&setting=access_controls' ),
			);
		}

		return $links;
	}

	/**
	 * Safe point to load all codes.
	 *
	 * @since 1.5.2.1
	 *
	 * @return mixed
	 */
	public function components_loaded() {
		if ( bbapp_is_active( 'access_controls' ) ) {
			\BuddyBossApp\AccessControls::instance();
			add_action( 'init', array( $this, 'load_on_init' ) );
		}
	}

	/**
	 * Code to load on init hook.
	 *
	 * @since 1.5.2.1
	 */
	public function load_on_init() {

	}
}
