<?php
/**
 * Holds third party plugins support functionality.
 *
 * @package BuddyBossApp
 */

namespace BuddyBossApp;

// @todo - Methods and vars needs to have PSR-4 standards. By Ketan, May-2019
// @FYI - old file name was : class.bbapp_api_plugin_support.php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Client third party plugins support.
 */
class ClientApiPluginSupport {
	/**
	 * ClientApiPluginSupport constructor.
	 */
	public function __construct() {
		add_action( 'rest_api_init', array( $this, 'api_init' ) );
	}

	/**
	 * Rest api init.
	 */
	public function api_init() {
		// Add visual composer shortcode support.
		add_filter( 'the_content', array( $this, 'add_visual_composer_support' ), 0 );

		// Elementor plugin json encode creating issue withs slider.
		if ( ! bbapp_is_rest() ) {
			return;
		}

		// Fixed html special character encoded issue.
		add_filter( 'the_title', array( $this, 'html_decode_entity' ), 999 );
		add_filter( 'the_content', array( $this, 'html_decode_entity' ), 999 );
		add_filter( 'the_excerpt', array( $this, 'html_decode_entity' ), 999 );
		add_filter( 'wp_trim_excerpt', array( $this, 'html_decode_entity' ), 999 );
	}

	/**
	 * Visual composer support.
	 *
	 * @param string $content Visual composer content.
	 *
	 * @return mixed
	 */
	public function add_visual_composer_support( $content ) {
		static $wpvc_mapped_loaded;

		if ( 1 !== (int) $wpvc_mapped_loaded && class_exists( '\WPBMap' ) ) {
			\WPBMap::addAllMappedShortcodes(); // This does all the work.
			$wpvc_mapped_loaded = 1;
		}

		return $content;
	}

	/**
	 * HTML entity decode.
	 *
	 * @param string $string String to decode.
	 *
	 * @return string
	 */
	public function html_decode_entity( $string ) {
		return html_entity_decode( $string, ENT_QUOTES );
	}
}
