<?php
/**
 * Holds Bookmarking initialization functionality.
 *
 * @package BuddyBossApp
 */

namespace BuddyBossApp;

use BB_Bookmark;
use BuddyBossApp\Bookmark\Actions;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Access Controls main class.
 */
final class Bookmark {

	/**
	 * Class instance.
	 *
	 * @var null $instance
	 */
	private static $instance = null;

	/**
	 * Integration array.
	 *
	 * @var array $integration
	 */
	public $integration = array();

	/**
	 * Conditions array.
	 *
	 * @var array $conditions
	 */
	public $conditions = array();

	/**
	 * Controller constructor.
	 *
	 * @since 1.7.4
	 */
	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * Get the instance of this class.
	 *
	 * @return Bookmark|null
	 */
	public static function instance() {
		if ( null === self::$instance ) {

			$class_name     = __CLASS__;
			self::$instance = new $class_name();
			self::$instance->setup_globals();
			self::$instance->load_classes();
			self::$instance->setup_actions();
			self::$instance->setup_filters();
		}

		return self::$instance;
	}

	/**
	 * Setup Globals.
	 *
	 * @since 1.7.4
	 */
	protected function setup_globals() {
	}

	/**
	 * Initiate the required classes.
	 *
	 * @since 1.7.4
	 */
	protected function load_classes() {
	}

	/**
	 * Action hooks
	 *
	 * @since 1.7.4
	 */
	protected function setup_actions() {
		add_action( 'init', array( $this, 'load_integrations' ), 1 );

	}

	/**
	 * Define all filter hooks.
	 *
	 * @since 1.7.4
	 *
	 * @return void
	 */
	protected function setup_filters() {
	}

	/**
	 * Load the integrations.
	 *
	 * @since 1.7.4
	 */
	public function load_integrations() {
		// Load all action.
		Actions::instance();

		// Load bookmark post.
		Bookmark_Posts::instance();

		// Load the API.
		\BuddyBossApp\Api\Bookmark\Main::instance();
	}

	/**
	 * Is post bookmark is enable.
	 *
	 * @since 1.7.4
	 * @return bool
	 */
	public function bb_is_post_bookmark_enable() {
		$settings = \BuddyBossApp\Admin\Settings::instance()->get_global_settings();
		if ( isset( $settings['post_bookmark_enable'] ) && true === (bool) $settings['post_bookmark_enable'] ) {
			return true;
		}

		return false;
	}

	/**
	 * When BuddyBoss App plugin is activated
	 *
	 * @since 1.7.4
	 */
	public function on_activation() {

		global $wpdb;

		$charset_collate = $wpdb->get_charset_collate();

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';

		$sql = "CREATE TABLE {$wpdb->prefix}bb_bookmarks (
			id bigint(20) unsigned NOT NULL auto_increment,
			blog_id bigint(20) DEFAULT NULL,
			user_id bigint(20) DEFAULT NULL,
			type varchar(20) DEFAULT NULL,
			item_id bigint(20) DEFAULT NULL,
			status tinyint(1) DEFAULT 1,
			date_recorded datetime DEFAULT '0000-00-00 00:00:00' NULL,
			PRIMARY KEY (id),
			KEY blog_id (blog_id),
			KEY user_id (user_id),
			KEY type (type),
			KEY item_id (item_id),
			KEY status (status),
			KEY date_recorded (date_recorded)
        ) {$charset_collate}";

		dbDelta( $sql );
	}

}
