<?php
/**
 * Holds Android publishing functionality.
 *
 * @package BuddyBossApp\AppStores\Services\Android
 */

namespace BuddyBossApp\AppStores\Services\Android;

use BuddyBossApp\AppStores\Android;
use BuddyBossApp\Admin\Configure;
use BuddyBossApp\AppStores\Components\Android\Edits;
use BuddyBossApp\AppStores\Components\Android\EditsDetails;
use BuddyBossApp\AppStores\Components\Android\EditsListings;
use BuddyBossApp\AppStores\Components\Android\EditsTracks;
use BuddyBossApp\AppStores\Components\Android\InAppProducts;

/**
 * Android publishing.
 */
class AndroidPublisher {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Package name.
	 *
	 * @var string $package_name
	 */
	private static $package_name;

	/**
	 * This will return instance of class
	 *
	 * @return AndroidPublisher
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Initialize Service for Android Publisher
	 *
	 * @param string $operation Action name.
	 *
	 * @return false|mixed|string
	 */
	public function initialize( $operation = 'EditsDetails' ) {
		self::$package_name = Configure::instance()->option( 'publish.android.namespace' );

		if ( empty( self::$package_name ) ) {
			return false;
		}

		$client = Android::instance()->get_client();

		if ( empty( $client ) || is_wp_error( $client ) ) {
			return false;
		}

		$android_publisher_service = \BuddyBossApp\Library\Composer::instance()->google_instance()->Google_Service_AndroidPublisher( $client );
		$android_publisher         = '';

		// Step-1 : Get EditId to start making changes.
		$edit_data = Edits::insert( $android_publisher_service );

		if ( empty( $edit_data->id ) ) {
			return false;
		}

		$edit_id = $edit_data->id;

		switch ( $operation ) {
			case 'Edits':
				// Operation : Get Edit Details.
				$android_publisher = Edits::get( $android_publisher_service, $edit_id );
				break;
			case 'EditsTracks':
				// Operation : tracks.
				$android_publisher = EditsTracks::get( $android_publisher_service, $edit_id );
				break;
			case 'EditsListings':
				// Operation : Listing.
				$android_publisher = EditsListings::listing( $android_publisher_service, $edit_id );
				break;
			case 'EditsDetails':
				// Operation : Get App Details.
				$android_publisher = EditsDetails::get( $android_publisher_service, $edit_id );
				break;
			case 'InAppProducts':
				// Operation : InAppProducts.
				$android_publisher = InAppProducts::listing();
				break;
		}

		return $android_publisher;
	}

	/**
	 * Function to check google account permissions.
	 *
	 * @return mixed
	 */
	public function operation_permission() {
		$operations = array(
			'Edits',
			'EditsTracks',
			'EditsListings',
			'EditsDetails',
			'InAppProducts',
		);

		foreach ( $operations as $operation ) {
			try {
				$operation = $this->initialize( $operation );
				$pass      = ( false === $operation ) ? false : true;
			} catch ( \Exception $e ) {
				$errors = $e->getMessage();
				$pass   = false;
			}

			if ( false === $pass ) {
				break;
			}
		}

		return $pass;
	}
}
