<?php
/**
 * Holds Android app IAP products listing functionality.
 *
 * @package BuddyBossApp\AppStores\Components\Android
 */

namespace BuddyBossApp\AppStores\Components\Android;

use BuddyBossApp\Admin\Configure;
use Google\Service\AndroidPublisher;

/**
 * Android IAP products.
 */
class InAppProducts {

	/**
	 * Package name.
	 *
	 * @var string $package_name
	 */
	private static $package_name;

	/**
	 * Lists all localized store listings using custom GooglePlayAPI wrapper.
	 *
	 * @param AndroidPublisher $android_publisher_service Android publisher class (unused, kept for compatibility).
	 *
	 * @return array Array containing formatted products.
	 * @since 2.9.1 Updated to use custom GooglePlayAPI for PHP 7.4 compatibility.
	 */
	public static function listing() {
		// Note: $android_publisher_service parameter kept for backward compatibility but not used.
		self::$package_name = Configure::instance()->option( 'publish.android.namespace' );

		$products = array();

		try {
			// Use our custom GooglePlayAPI wrapper for PHP 7.4 compatibility.
			$google_client = \BuddyBossApp\AppStores\Android::instance()->get_client();

			if ( ! empty( $google_client ) && ! is_wp_error( $google_client ) ) {
				$google_play_api = \BuddyBossApp\Library\Composer::instance()->google_play_api_instance();
				$google_play_api->init( $google_client, self::$package_name );

				// Get all products using the unified method.
				$all_products = $google_play_api->get_all_products();

				// Separate products by type to maintain expected structure.
				if ( ! empty( $all_products ) ) {
					foreach ( $all_products as $product ) {
						if ( 'subscription' === $product['type'] ) {
							$products['subscriptions'][] = $product;
						} else {
							$products['onetimeproducts'][] = $product;
						}
					}
				}
			}
		} catch ( \Exception $e ) {
			// Fall back to empty products array if API calls fail.
			$products = array();
		}

		return $products;
	}
}
