<?php
/**
 * Holds Android app edit functionality.
 *
 * @package BuddyBossApp\AppStores\Components\Android
 */

namespace BuddyBossApp\AppStores\Components\Android;

use BuddyBossApp\Admin\Configure;
use Google\Service\AndroidPublisher;

/**
 * Android app edit class.
 */
class EditsTracks {

	/**
	 * Package name.
	 *
	 * @var string $package_name
	 */
	private static $package_name;

	/**
	 * Lists all tracks. (tracks.listEditsTracks)
	 *
	 * @param AndroidPublisher $android_publisher_service Android publisher class.
	 * @param string           $edit_id                   Identifier of the edit.
	 *
	 * @return mixed
	 */
	public static function get( $android_publisher_service, $edit_id ) {
		self::$package_name = Configure::instance()->option( 'publish.android.namespace' );

		/**
		 * Method  : Get
		 * Gets testers.
		 * Read More : https://developers.google.com/android-publisher/api-ref/rest/v3/edits.testers/get
		 */
		return $android_publisher_service->edits_tracks->listEditsTracks( self::$package_name, $edit_id );
	}
}
