<?php
/**
 * Holds Android App edit functionality.
 *
 * @package BuddyBossApp\AppStores\Components\Android
 */

namespace BuddyBossApp\AppStores\Components\Android;

use BuddyBossApp\Admin\Configure;
use Google\Service\AndroidPublisher;

/**
 * Android App edit class.
 */
class EditsListings {

	/**
	 * Package name.
	 *
	 * @var string $package_name
	 */
	private static $package_name;

	/**
	 * Lists all localized store listings.
	 *
	 * @param AndroidPublisher $android_publisher_service Android publisher class.
	 * @param string           $edit_id                   Identifier of the edit.
	 *
	 * @return mixed
	 */
	public static function listing( $android_publisher_service, $edit_id ) {
		self::$package_name = Configure::instance()->option( 'publish.android.namespace' );

		/**
		 * Method  : List
		 * Lists all localized store listings.
		 * Read More  : https://developers.google.com/android-publisher/api-ref/rest/v3/edits.listings/list
		 */
		return $android_publisher_service->edits_listings->listEditsListings( self::$package_name, $edit_id );
	}
}
