<?php
/**
 * Holds the Android edit details functionality.
 *
 * @package BuddyBossApp\AppStores\Components\Android
 */

namespace BuddyBossApp\AppStores\Components\Android;

use BuddyBossApp\Admin\Configure;
use Google\Service\AndroidPublisher;

/**
 * Android App edit details class.
 */
class EditsDetails {

	/**
	 * Package name.
	 *
	 * @var string $package_name
	 */
	private static $package_name;

	/**
	 * Gets details of an app.
	 * Read More : https://developers.google.com/android-publisher/api-ref/rest/v3/edits.details/get
	 *
	 * @param AndroidPublisher $android_publisher_service Android publisher class.
	 * @param string           $edit_id                   Identifier of the edit.
	 *
	 * @return mixed
	 */
	public static function get( $android_publisher_service, $edit_id ) {
		self::$package_name = Configure::instance()->option( 'publish.android.namespace' );

		/**
		 * Gets details of an app. (details.get)
		 *
		 * @param string $packageName Package name of the app.
		 * @param string $edit_id     Identifier of the edit.
		 *
		 * @return /Google_Service_AndroidPublisher_AppDetails
		 */
		return $android_publisher_service->edits_details->get( self::$package_name, $edit_id );
	}
}
