<?php
/**
 * Holds Android Edit functionality.
 *
 * @package BuddyBossApp\AppStores\Components\Android
 */

namespace BuddyBossApp\AppStores\Components\Android;

use BuddyBossApp\Admin\Configure;
use Google\Service\AndroidPublisher;

/**
 * Android Edit class.
 */
class Edits {

	/**
	 * Package name.
	 *
	 * @var string $package_name
	 */
	private static $package_name;

	/**
	 * Creates a new edit for an app.
	 * Read More : https://developers.google.com/android-publisher/api-ref/rest/v3/edits/insert
	 *
	 * @param AndroidPublisher $android_publisher_service Android publisher class.
	 *
	 * @return mixed
	 */
	public static function insert( $android_publisher_service ) {
		self::$package_name = Configure::instance()->option( 'publish.android.namespace' );

		if ( ! self::$package_name ) {
			return false;
		}

		/**
		 * Creates a new edit for an app. (edits.insert)
		 *
		 * @param string $packageName Package name of the app.
		 * @param  /Google_Service_AndroidPublisher_AppEdit $postBody
		 *
		 * @return /Google_Service_AndroidPublisher_AppEdit
		 */
		$app_edit = \BuddyBossApp\Library\Composer::instance()->google_instance()->Google_Service_AndroidPublisher_AppEdit();
		$app_edit->setId( 'initiate-app-edit' );
		$app_edit->setExpiryTimeSeconds( 300 ); // 5 minutes (300 seconds)

		try {
			$new_app_edit = $android_publisher_service->edits->insert( self::$package_name, $app_edit );

			return $new_app_edit;
		} catch ( \Exception $new_app_edit ) {
			return $new_app_edit->getErrors();
		}
	}

	/**
	 * Gets an app edit.
	 * Read More : https://developers.google.com/android-publisher/api-ref/rest/v3/edits/get
	 *
	 * @param AndroidPublisher $android_publisher_service Android publisher class.
	 * @param string           $edit_id                   Identifier of the edit.
	 *
	 * @return mixed
	 */
	public static function get( $android_publisher_service, $edit_id ) {
		self::$package_name = Configure::instance()->option( 'publish.android.namespace' );
		$opt_params         = array();

		/**
		 * Gets an app edit. (edits.get)
		 *
		 * @param string $packageName Package name of the app.
		 * @param string $edit_id      Identifier of the edit.
		 * @param array  $opt_params   Optional parameters.
		 *
		 * @return /Google_Service_AndroidPublisher_AppEdit
		 */
		return $android_publisher_service->edits->get( self::$package_name, $edit_id, $opt_params );
	}
}
