<?php
/**
 * Holds including different app stores functionality.
 *
 * @package BuddyBossApp
 */

namespace BuddyBossApp;

use BuddyBossApp\Admin\Configure;
use BuddyBossApp\AppStores\Apple;
use BuddyBossApp\Builds\Installer;
use BuddyBossApp\Builds\InstallerScreen;
use BuddyBossApp\ClientCommon;
use BuddyBossApp\ManageApp;

/**
 * AppStores class.
 */
class AppStores {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return AppStores
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Build constructor.
	 */
	public function __construct() {
	}

	/**
	 * Filters/hooks here.
	 */
	public function load() {
		Apple::instance();
	}
}
