<?php
/**
 * Holds IAP feature availability functionality.
 *
 * @package BuddyBossApp\App
 */

namespace BuddyBossApp\App;

use BuddyBossApp\Admin\Configure;

/**
 * IAP products class.
 */
class IapProducts {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * IapProducts constructor.
	 */
	public function __construct() {
		// Using Singleton, see instance().
	}

	/**
	 * Singleton.
	 *
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Filters/hooks here.
	 */
	public function load() {
		App::instance()->add_local_feature(
			'in_app_purchases',
			array(
				'is_enabled_android' => true,
				'is_enabled_ios'     => true,
			)
		);

		/**
		 * Register menus & widgets.
		 */
		add_filter( 'bbapp_feature_availability_in_app_purchases', array( $this, 'feature_availability' ), 1, 1 );
	}

	/**
	 * Feature availability check for InAppPurchase
	 * NOTE : The feature can still be disabled by BuddyBossApp(control center, old-name: customer center) doesn't matter what's the status here
	 *
	 * @param array $feature Features.
	 *
	 * @return mixed
	 */
	public function feature_availability( $feature ) {
		$feature['is_enabled_ios']     = false;
		$feature['is_enabled_android'] = false;

		if ( bbapp_is_active( 'iap' ) ) {
			// On Admin UI: iOs(icon) App Shared Secret.
			$ios_secret = Configure::instance()->option( 'publish.ios.shared_secret' );
			// On Admin UI: Android(icon) Service Account Key.
			$android_key = Configure::instance()->option( 'publish.android.account_key' );
			if ( bbapp_is_connected_as_secondary_site() ) {
				$ios_secret  = true;
				$android_key = true;
			}
			$feature['is_enabled_ios']     = ! empty( $ios_secret );
			$feature['is_enabled_android'] = ! empty( $android_key );
		}

		return $feature;
	}
}
