<?php
/**
 * Holds app class functionality.
 *
 * @package BuddyBossApp\App
 */

namespace BuddyBossApp\App;

/**
 * App class.
 */
class App {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * App constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return App
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Load feature.
	 */
	public function load() {
		// load the feature.
		Features::instance();

		if ( bbapp_is_active( 'iap' ) ) {
			IapProducts::instance();
		}
	}

	/**
	 * This function allow to easily add local feature into BuddyBossApp feature list.
	 * Feature in this list are only local and has nothing to do with bbapp feature list.
	 *
	 * @param string $feature_name Feature name.
	 * @param array  $status       Feature status.
	 *
	 * @return mixed
	 */
	public function add_local_feature(
		$feature_name, $status = array(
			'is_enabled_ios'     => false,
			'is_enabled_android' => false,
		)
	) {
		global $bbapp_local_features;

		$feature_status = array(
			'is_enabled_ios'     => false,
			'is_enabled_android' => false,
		);

		/**
		 * Make sure to adopt only those feature which are in above array $feature_status
		 */
		foreach ( $feature_status as $status_name => $status_value ) {

			if ( isset( $status[ $status_name ] ) ) {
				$feature_status[ $status_name ] = $status[ $status_name ];
			}
		}

		$bbapp_local_features[ $feature_name ] = $feature_status;

		return $bbapp_local_features;
	}

	/**
	 * Returns the BuddyBossApp Local Features.
	 *
	 * @return array
	 */
	public function get_local_features() {
		global $bbapp_local_features;

		if ( ! isset( $bbapp_local_features ) || ! is_array( $bbapp_local_features ) ) {
			$bbapp_local_features = array();
		}

		$features = array();

		foreach ( $bbapp_local_features as $feature_name => $feature_status ) {

			$features[ $feature_name ] = array(
				'is_enabled_ios'     => false,
				'is_enabled_android' => false,
			);

			if ( isset( $feature_status['is_enabled_ios'] ) ) {
				$features[ $feature_name ]['is_enabled_ios'] = $feature_status['is_enabled_ios'];
			}

			if ( isset( $feature_status['is_enabled_android'] ) ) {
				$features[ $feature_name ]['is_enabled_android'] = $feature_status['is_enabled_android'];
			}
		}

		$features = apply_filters( 'bbapp_local_features', $features );

		return $features;
	}

	/**
	 * Return the app features filtered by plugins with real status of their presence.
	 *
	 * Possible Filters.
	 * bbapp_feature_availability_multisite_network
	 * bbapp_feature_availability_in_app_purchases
	 * .. etc
	 *
	 * @return mixed|void
	 */
	public function get_app_features_availability() {

		$features = array();

		foreach ( $this->get_local_features() as $feature_name => $feature_status ) {
			if ( ! isset( $features[ $feature_name ] ) ) {
				$features[ $feature_name ] = $feature_status;
				$features[ $feature_name ] = apply_filters( "bbapp_feature_availability_{$feature_name}", $features[ $feature_name ] );
			}
		}

		return apply_filters( 'bbapp_features_availability', $features );
	}

}

