<?php // phpcs:disable

/**
 * API doc class.
 *
 * @package BuddyBossApp
 */

namespace BuddyBossApp;

/**
 * The soul purpose of this class is apidoc(documentation generator). By Ketan
 * Todo: Ignore this file on wpcs because it's help to generate api doc.
 */
class ApidocV1 {

	/**
	 * Social auth v1.
	 */
	private function apidocForGetSocialAuthV1() {
		/**
		 * Social auth v1.
		 *
		 * @apiDefine apidocForGetSocialAuthV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 *
		 * @apiParam {String} [app_id=null] App Id (interchangeably used with unique_id, at-least one is required)
		 * @apiParam {String} [unique_id=null] App Id (interchangeably used with app_id, at-least one is required)
		 * @apiParam {String=facebook,google,twitter} service Provide a valid network service.
		 * @apiParam {String} token User Access Token of selected social service
		 * @apiParam {String} link_password User account password, only require when endpoint ask in return.
		 * @apiParam {String} token_secret User Access Token Secret of selected social service.
		 * @apiSuccessExample {json} Success-Response:
		 *    {
		 *    "accesstoken": "secret"
		 *    }
		 */
	}

	/**
	 * Item meta v1.
	 */
	private function apidocForItemMetaV1() {
		/**
		 * Item meta v1.
		 *
		 * @apiDefine apidocForItemMetaV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} item_id Item ID
		 * @apiParam {String=course,lesson,topic} item_type Item Type
		 * @apiSuccessExample {json} Response(item_type=course):
		 *    {
		 *    "updates": {
		 *      "last_changed": 1572641500,
		 *      "child_updated": [],
		 *      "parent_updated": []
		 *      },
		 *      "child_ids": [],
		 *      "parent_ids": []
		 *    }
		 * @apiSuccessExample {json} Response(item_type=lesson):
		 *    {
		 *    "updates": {
		 *      "last_changed": 1572641500,
		 *      "child_updated": [],
		 *      "parent_updated": []
		 *      },
		 *      "child_ids": [],
		 *      "parent_ids": []
		 *    }
		 * @apiSuccessExample {json} Response(item_type=topic):
		 *    {
		 *    "updates": {
		 *      "last_changed": 1572641500,
		 *      "child_updated": [],
		 *      "parent_updated": []
		 *      },
		 *      "child_ids": [],
		 *      "parent_ids": []
		 *    }
		 */
	}

	/**
	 * Item meta since.
	 */
	private function apidocForItemsMetaSinceV1() {
		/**
		 * Item meta since.
		 *
		 * @apiDefine apidocForItemsMetaSinceV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String=course,lesson,topic} item_type Item Type.
		 * @apiParam {Array} [item_ids Item IDs
		 * @apiParam {String} [timestamp] Get meta since specified Timestamp
		 * @apiSuccessExample {json} Response(item_type=course):
		 *    {
		 *      "<item_id>" : {
		 *          "updates": {
		 *              "last_changed": 1572641500,
		 *              "child_updated": 1573591701,
		 *              "parent_updated": 0
		 *          },
		 *          "child_ids": [],
		 *          "parent_ids": []
		 *    },
		 *      "<item_id>" : {
		 *          "updates": {
		 *              "last_changed": 1572641511,
		 *              "child_updated": 0,
		 *              "parent_updated":
		 *          },
		 *          "child_ids": [],
		 *          "parent_ids": []
		 *    },
		 * }
		 * @apiSuccessExample {json} Response(item_type=lesson):
		 *    {
		 *      "<item_id>" : {
		 *          "updates": {
		 *              "last_changed": 1572641522,
		 *              "child_updated": ["66","77"],
		 *              "parent_updated": ["2401"]
		 *          },
		 *          "child_ids": [],
		 *          "parent_ids": []
		 *    },
		 *      "<item_id>" : {
		 *          "updates": {
		 *              "last_changed": 1572641533,
		 *              "child_updated": ["33","44"],
		 *              "parent_updated": ["544"]
		 *          },
		 *          "child_ids": [],
		 *          "parent_ids": []
		 *    },
		 * }
		 * @apiSuccessExample {json} Response(item_type=topic):
		 *    {
		 *      "<item_id>" : {
		 *          "updates": {
		 *              "last_changed": 1572641522,
		 *              "child_updated": ["166","177"],
		 *              "parent_updated": ["401"]
		 *          },
		 *          "child_ids": [],
		 *          "parent_ids": []
		 *    },
		 *      "<item_id>" : {
		 *          "updates": {
		 *              "last_changed": 1572641533,
		 *              "child_updated": ["133","144"],
		 *              "parent_updated": ["144"]
		 *          },
		 *          "child_ids": [],
		 *          "parent_ids": []
		 *    },
		 * }
		 */
	}

	/**
	 * Menu settings v1.
	 */
	private function apidocForCoreMenuSettingsV1() {
		/**
		 * Menu settings v1.
		 *
		 * @apiDefine apidocForCoreMenuSettingsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String} app_id App Id
		 * @apiSuccessExample {json} Success-Response:
		 *[
		 *    {
		 *        "name": "home",
		 *        "label": "Home",
		 *        "type": "app_page",
		 *        "data": {
		 *            "id": 459,
		 *            "link": "http://localhost:8888/app_page/home/",
		 *            "parent": 0,
		 *            "show_search": false,
		 *            "open_external": false
		 *        },
		 *        "settings": [],
		 *        "on": true,
		 *        "icon": {
		 *            "ios_uri": "",
		 *            "android_uri": "",
		 *            "ios": "",
		 *            "android": ""
		 *        }
		 *    },
		 *    {
		 *        "label": "Courses",
		 *        "data": {
		 *            "classes": "",
		 *            "link": "#",
		 *            "id": "courses",
		 *            "parent": "5d8000eb5966e",
		 *            "course_ids": ["6","10"],
		 *            "mycourses": false,
		 *            "show_search": false,
		 *            "open_external": false
		 *        },
		 *        "icon": {
		 *            "ios_uri": "",
		 *            "android_uri": "",
		 *            "ios_tint_color": "#908DA1",
		 *            "android_tint_color": "#908DA1"
		 *        },
		 *        "name": "courses",
		 *        "type": "core"
		 *    },
		 *    {
		 *        "label": "Course Categories",
		 *        "data": {
		 *        "classes": "",
		 *        "link": "#",
		 *        "id": "courses_category",
		 *        "parent": "0",
		 *        "category_ids": ["20","22"],
		 *        "mycourses": false,
		 *        "show_search": false,
		 *        "open_external": false
		 *        },
		 *        "icon": {
		 *            "ios_uri": "",
		 *            "android_uri": "",
		 *            "ios_tint_color": "#908DA1",
		 *            "android_tint_color": "#908DA1"
		 *        },
		 *        "name": "courses_category",
		 *        "type": "core"
		 *    }
		 *]
		 */
	}

	/**
	 * App core settings.
	 */
	private function apidocForGetCoreSettingsV1() {
		/**
		 * App core settings.
		 *
		 * @apiDefine apidocForGetCoreSettingsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiHeader {String} appplatform Platform OS. Eg :ios, android
		 * @apiParam {String} app_id AppId (Used interchangeable with unique_id,one of them is `required`)
		 * @apiParam {String} unique_id (Used interchangeable with app_id, one of them is `required`)
		 * @apiSuccessExample {json} Success-Response:
		 * {
		 * "config": {
		 * "demo": {
		 * "is": false,
		 * "username": "",
		 * "password": ""
		 * },
		 * "language": "en_US",
		 * "bugs_email": "bbapp@example.org",
		 * "support_email": "bbapp@example.org"
		 * },
		 * "app_auth": {
		 * "enable_signup": true,
		 * "enable_inapp_account_verification": false
		 * },
		 * "app_menu": {
		 * "ios": {
		 * "show_labels": false,
		 * "tabbar_more_menu_icon": {
		 * "uri": "http://example.org/wp-content/plugins/bbapp/assets/app-icons/feather-menu.png",
		 * "tint_color": ""
		 * }
		 * },
		 * "android": {
		 * "show_labels": false,
		 * "tabbar_more_menu_icon": {
		 * "uri": "http://example.org/wp-content/plugins/bbapp/assets/app-icons/feather-menu.png",
		 * "tint_color": ""
		 * }
		 * }
		 * },
		 * "general": {
		 * "ios": {
		 * "store_app_id": ""
		 * }
		 * },
		 * "app_rating": {
		 * "ios": {
		 * "enabled": false,
		 * "store_app_id": "",
		 * "store_app_locale": ""
		 * },
		 * "android": {
		 * "enabled": false
		 * }
		 * },
		 * "branding": {
		 * "styles": {
		 * "colors": {
		 * "primaryColor": "#8224e3",
		 * "highlightColor": "#007cff",
		 * "linkColor": "#516CD9",
		 * "bodyFrontBg": "#FFFFFF",
		 * "bodyBg": "#f6f6f8",
		 * "tagsBg": "#ffffff",
		 * "tagsColor": "#000000",
		 * "borderColor": "#E7E9EC",
		 * "headerBg": "#FFFFFF",
		 * "headerColor": "#211C44",
		 * "headerIconColor": "#908DA1",
		 * "bottomTabsBg": "#EEF0F3",
		 * "bottomTabsColor": "#122b46",
		 * "bottomTabsActiveColor": "#007cff",
		 * "drawerColor": "#4d5c6d",
		 * "drawerActiveColor": "#516cd9",
		 * "drawerBg": "#211C44",
		 * "primaryButtonBg": "#013A7E",
		 * "primaryButtonColor": "#ffffff",
		 * "secondaryButtonBg": "#F9F9F9",
		 * "secondaryButtonColor": "#516CD9",
		 * "textColor": "#122B46",
		 * "headingsColor": "#211C44",
		 * "descTextColor": "#737679",
		 * "descLightTextColor": "#a3a6a9",
		 * "successColor": "#10D639",
		 * "notifColor": "#EF6E00",
		 * "warningColor": "#F5564C",
		 * "androidStatusBgColor": "#FFFFFF"
		 * },
		 * "statusBar": {
		 * "iosStatusWithCoverColor": "light-content",
		 * "iosStatusWithoutCoverColor": "dark-content",
		 * "androidStatusColor": "light-content"
		 * },
		 * "auth": {
		 * "style": "dark-content"
		 * },
		 * "typography": {
		 * "bodyText": {
		 * "family": "Default",
		 * "size": "14",
		 * "weight": "normal"
		 * },
		 * "bodyTextContent": {
		 * "family": "Default",
		 * "size": "16",
		 * "weight": "normal"
		 * },
		 * "caption": {
		 * "family": "Default",
		 * "size": "13",
		 * "weight": "normal"
		 * },
		 * "widgetTitle": {
		 * "family": "Default",
		 * "size": "22",
		 * "weight": "normal"
		 * },
		 * "filterText": {
		 * "family": "Default",
		 * "size": "14",
		 * "weight": "normal"
		 * },
		 * "appHeaderTitle": {
		 * "family": "Default",
		 * "size": "20",
		 * "weight": "normal"
		 * },
		 * "heading1": {
		 * "family": "Default",
		 * "size": "30",
		 * "weight": "normal"
		 * },
		 * "heading2": {
		 * "family": "Default",
		 * "size": "24",
		 * "weight": "normal"
		 * },
		 * "heading3": {
		 * "family": "Default",
		 * "size": "22",
		 * "weight": "normal"
		 * },
		 * "heading4": {
		 * "family": "Default",
		 * "size": "20",
		 * "weight": "normal"
		 * },
		 * "heading5": {
		 * "family": "Default",
		 * "size": "17",
		 * "weight": "normal"
		 * },
		 * "heading6": {
		 * "family": "Default",
		 * "size": "14",
		 * "weight": "normal"
		 * }
		 * }
		 * },
		 * "home_screen_logo": "http://example.org/wp-content/uploads/bbapp-branding/ab5c61b/1/home_screen_logo.png?1579531121",
		 * "login_logo": "",
		 * "login_background_img": "",
		 * "splash_screen_img": "http://example.org/wp-content/uploads/bbapp-branding/ab5c61b/1/splash_screen_img.png?1592245812",
		 * "splash_show_spinner": true,
		 * "splash_spinner_color": "#eeee22",
		 * "app_icon_ios": "http://example.org/wp-content/uploads/bbapp-branding/ab5c61b/1/app_icon_ios.png?1592217162",
		 * "app_icon_android": "http://example.org/wp-content/uploads/bbapp-branding/ab5c61b/1/app_icon_android.png?1592217162",
		 * "app_icon_android_adaptive_bg": "http://example.org/wp-content/uploads/bbapp-branding/ab5c61b/1/app_icon_android_adaptive_bg.png?1586399011",
		 * "app_icon_android_adaptive_fg": "http://example.org/wp-content/uploads/bbapp-branding/ab5c61b/1/app_icon_android_adaptive_fg.png?1586399012",
		 * "app_icon_android_notification": ""
		 * },
		 * "languages": {
		 * "en_US": {
		 * "common.failDefaultMessage": "Server request failed lol :D I am loving this.",
		 * "common.default": "Server error or connection is lost. Try again later",
		 * "common.cancelSearch": "Cancel",
		 * "common.retry": "Retry",
		 * "common.cancel": "Cancel",
		 * "..."
		 * }
		 * },
		 * "features": {
		 * "push_notifications": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "multisite_network": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "learner_app": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "in_app_purchases": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "app_switch_user": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "social_login": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "apple_login": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "facebook_login": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "google_login": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "twitter_login": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "buddyboss_media": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "intercom": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "forum_app": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "social_app": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "app.show_activity_tabs_member_profile": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "app.show_activity_filter_member_profile": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "admob": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "offline": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "learndash.offline": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "learndash.author_visible": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "learndash.date_visible": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.notifications": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.friend_connections": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.user_groups": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.followers": {
		 * "is_enabled_android": false,
		 * "is_enabled_ios": false
		 * },
		 * "buddypress.activity_streams": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.activity_streams.profile.media.photo": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.activity_streams.group.media.photo": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.extended_profiles": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.account_settings": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * },
		 * "buddypress.private_messaging": {
		 * "is_enabled_android": true,
		 * "is_enabled_ios": true
		 * }
		 * },
		 * "multisite_network": {
		 * "enabled": true,
		 * "network_mode": false
		 * },
		 * "vimeo": {
		 * "referer": "http://example.org"
		 * },
		 * "moderation": {
		 * "user": {
		 * "active": 1,
		 * "reportable_items": [
		 * "user"
		 * ]
		 * },
		 * "forums": {
		 * "active": 0,
		 * "reportable_items": []
		 * },
		 * "bp_activity": {
		 * "active": 0,
		 * "reportable_items": []
		 * }
		 * },
		 * "iap": {
		 * "lock_app": false,
		 * "subscribe_message": null,
		 * "test_mode": false
		 * },
		 * "learndash": {
		 * "labels": {
		 * "course": "Course",
		 * "courses": "Courses",
		 * "lesson": "Lesson",
		 * "lessons": "Lessons",
		 * "topic": "Topic",
		 * "topics": "Topics",
		 * "quiz": "Quiz",
		 * "quizzes": "Quizzes",
		 * "question": "Question",
		 * "questions": "Questions",
		 * "button_take_this_course": "Take this Course",
		 * "button_mark_complete": "Mark Complete",
		 * "button_click_here_to_continue": "Click Here to Continue"
		 * }
		 * }
		 * }
		 */
	}

	/**
	 * Core home page settings v1.
	 *
	 * @since 1.8.20
	 */
	private function apidocForCoreHomePageSettingsV1() {
		/**
		 * Core home page settings v1.
		 *
		 * @apiDefine apidocForCoreHomePageSettingsV1
		 *
		 * @apiParam {String} app_id App Id
		 * @apiSuccessExample {json} Success-Response:
		 *    {
		 *    "widgets": [],
		 *    "dependent_addons": []
		 *    }
		 */
	}

	/**
	 * Get app details.
	 */
	private function apidocForGetAppDetailsV1() {
		/**
		 * Get app details.
		 *
		 * @apiDefine apidocForGetAppDetailsV1
		 *
		 * @apiParam {String} app_id App Id
		 * @apiSuccessExample {json} Success-Response:
		 *    {
		 *    "data": "{\"appstore_id\":false,\"appstore_locale\":\"\",\"support_email\":\"someone@example.com\",\"app_name\":\"Ketan-Local\",\"app_id\":\"082be4\",\"bugs_reporting_email\":\"someone@example.com\",\"features\":{\"multisite_network\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"in_app_purchases\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"social_login\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"push_notifications\":{\"is_enabled_ios\":true,\"is_enabled_android\":true},\"social_app\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"forum_app\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"learner_app\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"bugsnag_bug_reports\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.extended_profiles\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.account_settings\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.friend_connections\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.private_messaging\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.activity_streams\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.notifications\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.user_groups\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddypress.followers\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"buddyboss_media\":{\"is_enabled_ios\":false,\"is_enabled_android\":false},\"intercom\":{\"is_enabled_ios\":false,\"is_enabled_android\":false}},\"exp\":1564261822}",
		 *    "algo": "rsa-sha256",
		 *    "sign": "J8dtYzuOUouTtopmfi5J1ce4nYROWX06rWNSdouTQkzen5TJ0/C6BQ3xa3tz+7WWG9Q99OU7FLP+RPE7biWaIHFJk7uSdPSY0XE9fDYnuE1gj8aptwQGOqgBduqSxv5Q4dDc+WNrIbFgzV6s9l+4lzdPswB7MDY24mf5sNbnLWKHqj1RNzHeIpSJtY+8/W2zSf3KhBKeQ1jBt03UUwNx+92F8++81WxFxD8HXxuDVMYpxSuub6SeT9YEgLu+zz7f2TEatkHqpjqL04X8zdUniHUYM/iHnmgKgP3PchHSw4sPgIFDxfJP17q5Rep0A+NGarTTygQmJ5h/Nqg52uOYGw=="
		 *    }
		 */
	}

	/**
	 * Get lock.
	 */
	private function apidocGetLockAppV1() {
		/**
		 * Get lock.
		 *
		 * @apiDefine apidocGetLockAppV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiSuccessExample {json} Success-Response:
		 *    {
		 *    "lock_app": true,
		 *    "subscribe_message": "<h1>Subscribe to use features</h1><p>Override the default app message via backend</p>",
		 *    "products": [
		 *    {
		 *    "product_id": "1",
		 *    "product_name": "Product 1",
		 *    "product_desc": "On iOS and android device1",
		 *    "global_subscription": true,
		 *    "ios": {
		 *    "status": false,
		 *    "store_product_id": "com.example.ios-#",
		 *    "store_product_type": "consumable",
		 *    "recurring": false
		 *    },
		 *    "android": {
		 *    "status": true,
		 *    "store_product_id": "com.example.android-#",
		 *    "store_product_type": "non_consumable",
		 *    "recurring": true
		 *    }
		 *    },
		 *    {
		 *    "product_id": "2",
		 *    "product_name": "Product 2",
		 *    "product_desc": "On android",
		 *    "global_subscription": true,
		 *    "ios": {
		 *    "status": false,
		 *    "store_product_id": null,
		 *    "store_product_type": "consumable",
		 *    "recurring": false
		 *    },
		 *    "android": {
		 *    "status": true,
		 *    "store_product_id": "com.example.android-#",
		 *    "store_product_type": "non_consumable",
		 *    "recurring": true
		 *    }
		 *    }
		 *    ]
		 *    }
		 */
	}

	/**
	 * Function to Request token for V1.
	 */
	private function apidocForRequestTokenV1() {
		/**
		 * Request token for V1.
		 *
		 * @apiDefine apidocForRequestTokenV1
		 *
		 * @apiParam {String} username Username of user wants to authenticate.
		 * @apiParam {String} password Password of user wants to authenticate.
		 * @apiParam {String} unique_id App Id (interchangeably used with app_id, atleast one is required)
		 * @apiParam {String} app_id App Id (interchangeably used with unique_id, atleast one is required)required
		 * @apiSuccessExample {json} Success-Response:
		 *    {
		 *    "user_email": "someone@example.com",
		 *    "user_nicename": "nickname",
		 *    "user_display_name": "firstname",
		 *    "user_id": "#",
		 *    "token": "secret"
		 *    }
		 */
	}

	/**
	 * Item meta last change.
	 */
	private function apidocForItemMetaLastChangedV1() {
		/**
		 * Item meta last change.
		 *
		 * @apiDefine apidocForItemMetaLastChangedV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String=course,lesson,topic} item_type Item Type.
		 * @apiParam {String} item_id Item ID
		 * @apiParam {String} timestamp Get meta since specified Timestamp
		 * @apiSuccessExample {json} Response(item_type=course):
		 *  {
		 *      "self_changed" : 1572641500,
		 *      "child_updated": [
		 *      {
		 *      "id": 2963,
		 *      "type": "lesson"
		 *      },
		 *      {
		 *      "id": 496,
		 *      "type": "lesson"
		 *      },
		 *      {
		 *      "id": 497,
		 *      "type": "topic"
		 *      }
		 *      ],
		 *      "parent_updated": []
		 * }
		 */
	}
}
// phpcs:enable