<?php
/**
 * Holds Wp core rest functionality.
 *
 * @package BuddyBossApp\Api\WpCore
 */

namespace BuddyBossApp\Api\WpCore;

use BuddyBossApp\Api\WpCore\V2\BuddyBossApp_REST_Batch_Controller;
use BuddyBossApp\Api\WpCore\V2\RestAPI as RestAPIv2;

/**
 * Wp core rest functionality.
 */
class Main {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Register all hooks
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function hooks() {
		add_action( 'plugins_loaded', array( $this, 'load' ) );
	}

	/**
	 * Load WP Core API versions.
	 */
	public function load() {
		RestAPIv2::instance();

		add_action( 'rest_api_init', array( $this, 'load_bbapp_batch_api' ), 1 );
		add_action( 'rest_api_init', array( $this, 'register_additional_field' ), 99 );
	}

	/**
	 * Load batch api.
	 *
	 * @since 2.0.80
	 * @return void
	 */
	public function load_bbapp_batch_api() {
		$request_uri = ( ! empty( $_SERVER['REQUEST_URI'] ) ) ? bbapp_input_clean( sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) : '';

		if ( ! empty( $request_uri ) && false !== strpos( $request_uri, 'buddyboss-app/v1/batch' ) ) {
			global $wp_rest_server;

			$wp_rest_server = new BuddyBossApp_REST_Batch_Controller();
		}
	}

	/**
	 * Additional field data.
	 */
	public function register_additional_field() {
		register_rest_field(
			'user',
			'loggedin_user_permissions',
			array(
				'get_callback'    => array( $this, 'get_current_user_permissions' ),
				'update_callback' => null,
				'schema'          => null,
			)
		);
	}

	/**
	 * Function to return the current user permission.
	 *
	 * @return mixed|void
	 */
	public function get_current_user_permissions() {
		$user_permission = array(
			// used to View as functionality in app.
			'can_moderate' => current_user_can( 'edit_user' ),
			'is_admin'     => current_user_can( 'administrator' ),
		);

		return apply_filters( 'bbapp_user_permissions', $user_permission );
	}
}
