<?php
/**
 * Holds TutorLMS related API functionality.
 *
 * @package BuddyBossApp\Api\TutorLMS\V1
 */

namespace BuddyBossApp\Api\TutorLMS\V1;

// Make sure we don't expose any info if called directly.
use BuddyBossApp\Api\TutorLMS\V1\Assignments\AssignmentsActionRest;
use BuddyBossApp\Api\TutorLMS\V1\Assignments\AssignmentsRest;
use BuddyBossApp\Api\TutorLMS\V1\Course\CoursesActionRest;
use BuddyBossApp\Api\TutorLMS\V1\Course\CoursesGradebookRest;
use BuddyBossApp\Api\TutorLMS\V1\Course\CoursesResourcesRest;
use BuddyBossApp\Api\TutorLMS\V1\Course\CoursesRest;
use BuddyBossApp\Api\TutorLMS\V1\Course\QuestionAnswer\AnswersRest;
use BuddyBossApp\Api\TutorLMS\V1\Course\QuestionAnswer\QuestionsRest;
use BuddyBossApp\Api\TutorLMS\V1\Lesson\LessonsActionRest;
use BuddyBossApp\Api\TutorLMS\V1\Lesson\LessonsCommentRest;
use BuddyBossApp\Api\TutorLMS\V1\Lesson\LessonsRest;
use BuddyBossApp\Api\TutorLMS\V1\Quiz\QuizActionRest;
use BuddyBossApp\Api\TutorLMS\V1\Quiz\QuizAttemptRest;
use BuddyBossApp\Api\TutorLMS\V1\Quiz\QuizRest;

if ( ! function_exists( 'add_action' ) ) {
	die( "Sorry, you can't access this directly - Security established" );
}

/**
 * Class RestAPI
 *
 * @package BuddyBossApp\Api\TutorLMS\V1
 */
class RestAPI {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @since 2.2.80
	 * @return RestAPI
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Load all rest routes.
	 *
	 * @since 2.2.80
	 */
	public function load() {
		// Register all hooks.
		$this->hooks();
	}

	/**
	 * Register all hooks
	 *
	 * @since 2.2.80
	 * @return void
	 */
	public function hooks() {
		add_action( 'rest_api_init', array( $this, 'load_rest' ) );
	}

	/**
	 * Load all rest routes.
	 *
	 * @since 2.2.80
	 */
	public function load_rest() {
		// Settings.
		Settings::instance()->register_routes();
		// Courses.
		CoursesRest::instance()->register_routes();
		CoursesActionRest::instance()->register_routes();
		CoursesResourcesRest::instance()->register_routes();
		CoursesGradebookRest::instance()->register_routes();
		// QuestionAnswer.
		QuestionsRest::instance()->register_routes();
		AnswersRest::instance()->register_routes();
		// Lesson.
		LessonsRest::instance()->register_routes();
		LessonsCommentRest::instance()->register_routes();
		LessonsActionRest::instance()->register_routes();
		// Quiz.
		QuizRest::instance()->register_routes();
		QuizActionRest::instance()->register_routes();
		QuizAttemptRest::instance()->register_routes();

		// Assignments.
		AssignmentsRest::instance()->register_routes();
		AssignmentsActionRest::instance()->register_routes();

		// User Notifications.
		UserNotifications::instance()->register_routes();
	}
}
