<?php
/**
 * Holds quiz different errors.
 *
 * @package BuddyBossApp\Api\TutorLMS\V1\Quiz
 */

namespace BuddyBossApp\Api\TutorLMS\V1\Quiz;

use BuddyBossApp\RestErrors;
use WP_Error;

/**
 * Quiz error class.
 */
class QuizError {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @since 2.2.80
	 * @return QuizError
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * When a user is not logged in this error message should be used.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function user_not_logged_in() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When quiz id not correct.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_quiz_id() {
		return new WP_Error( 'tutor_json_quiz_invalid_id', __( 'Quiz not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * Quiz already started an error message.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function quiz_already_started() {
		return new WP_Error( 'quiz_already_started', __( 'Quiz already started.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Quiz start failed.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function quiz_start_failed() {
		return new WP_Error( 'quiz_start_failed', __( 'Quiz start failed.', 'buddyboss-app' ), array( 'status' => 500 ) );
	}

	/**
	 * You are not enrolled in this course.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function not_enrolled_in_course() {
		return new WP_Error( 'tutor_json_quiz_not_enrolled', __( 'You are not enrolled in this course.', 'buddyboss-app' ), array( 'status' => 403 ) );
	}

	/**
	 * Quiz complete failed.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function quiz_complete_failed() {
		return new WP_Error( 'quiz_complete_failed', __( 'Quiz complete failed.', 'buddyboss-app' ), array( 'status' => 500 ) );
	}

	/**
	 * Operation isn't allowed.
	 *
	 * @since  2.2.80
	 * @retrun WP_Error
	 */
	public function operation_not_allowed() {
		return new WP_Error( 'operation_not_allowed', __( 'Operation not allowed.', 'buddyboss-app' ), array( 'status' => 403 ) );
	}

	/**
	 * Attempt not found.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function attempt_not_found() {
		return new WP_Error( 'attempt_not_found', __( 'Attempt not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * Course not found.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function course_not_found() {
		return new WP_Error( 'course_not_found', __( 'Course not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * Invalid quiz answers.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_quiz_answers() {
		return new WP_Error( 'invalid_quiz_answers', __( 'Invalid quiz answers.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}
}
