<?php
/**
 * Holds Lessons related API functionality.
 *
 * @package BuddyBossApp\Api\TutorLMS\V1\Lesson
 */

namespace BuddyBossApp\Api\TutorLMS\V1\Lesson;

use BuddyBossApp\RestErrors;
use WP_Error;

/**
 * Class LessonsError
 *
 * @package BuddyBossApp\Api\TutorLMS\V1\Lesson
 */
class LessonsError {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @since 2.2.80
	 * @return LessonsError
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * When a user is not logged in, this error message should be used.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function user_not_logged_in() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When Lesson id not correct.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_lesson_id() {
		return new WP_Error( 'tutor_json_lesson_invalid_id', __( 'Lesson not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When Lesson's course id not correct on lesson actions.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_course_id() {
		return new WP_Error( 'tutor_json_lesson_invalid_course', __( 'Lesson\'s course not found! On which you performing action.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Lesson complete fails.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function lesson_complete_error() {
		return new WP_Error( 'tutor_json_lesson_complete_error', __( 'Something is wrong with complete process.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Lesson complete fails.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function lesson_complete_validation_error() {
		return new WP_Error( 'tutor_json_lesson_validate_error', __( 'There is something wrong with validation.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Lesson complete fails.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function lesson_comment_error() {
		return new WP_Error( 'tutor_json_lesson_comment_error', __( 'There is something wrong while adding lesson comment.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Lesson complete fails.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_lesson_comment_id() {
		return new WP_Error( 'tutor_json_lesson_invalid_comment_id', __( 'Lesson comment not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}
}
