<?php
/**
 * Holds TutorLMS course errors messages.
 *
 * @package BuddyBossApp\Api\TutorLMS\V1\Course
 */

namespace BuddyBossApp\Api\TutorLMS\V1\Course\QuestionAnswer;

use BuddyBossApp\RestErrors;
use WP_Error;

/**
 * TutorLMS course errors class.
 */
class QuestionsError {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @since 2.2.80
	 * @return QuestionsError
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * When a user is not logged in this error message should be used.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function user_not_logged_in() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When Course id not correct.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_question_id() {
		return new WP_Error( 'tutor_json_question_invalid_id', __( 'Question not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user need to access Q&A.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function access_denied() {
		return new WP_Error( 'tutor_json_qna_access_denied', __( 'You do not have access to this Q&A.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When empty question isn't allowed.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function empty_question_not_allowed() {
		return new WP_Error( 'tutor_json_empty_question_not_allowed', __( 'Empty question not allowed.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When empty answer isn't allowed.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function empty_answer_not_allowed() {
		return new WP_Error( 'tutor_json_empty_answer_not_allowed', __( 'Empty answer not allowed.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When error saving item.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function error_saving_item() {
		return new WP_Error( 'tutor_json_error_saving_item', __( 'Error saving item.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}
}
