<?php
/**
 * Holds TutorLMS course errors messages.
 *
 * @package BuddyBossApp\Api\TutorLMS\V1\Course
 */

namespace BuddyBossApp\Api\TutorLMS\V1\Course;

use BuddyBossApp\RestErrors;
use WP_Error;

/**
 * TutorLMS course errors class.
 */
class CoursesError {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @since 2.2.80
	 * @return CoursesError
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * When a user is not logged in, this error message should be used.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function user_not_logged_in() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When Course id not correct.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_course_id() {
		return new WP_Error( 'tutor_json_course_invalid_id', __( 'Course not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user need to purchase course.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function course_purchase_required() {
		return new WP_Error( 'tutor_json_course_purchase_required', __( 'You need to purchase this course before you can start.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user need to enroll course.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function course_enroll_required() {
		return new WP_Error( 'tutor_json_course_enroll_required', __( 'You need to enroll this course before you can complete.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user need to login to enroll course.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function course_login_required() {
		return new WP_Error( 'tutor_json_course_login_required', __( 'You need to login to enroll this course.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user need to log in to complete the course.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function course_complete_error() {
		return new WP_Error( 'tutor_json_course_complete_error', __( 'Error while completing course.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When error saving item.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function error_saving_item() {
		return new WP_Error( 'tutor_json_error_saving_item', __( 'Error while saving item.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When question not found.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function question_not_found() {
		return new WP_Error( 'tutor_json_question_not_found', __( 'Question not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When no grade book data.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function no_gradebook_data() {
		return new WP_Error( 'tutor_json_no_gradebook_data', __( 'No Gradebook Data', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When no grading system.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function no_grading_system() {
		return new WP_Error( 'tutor_json_no_grading_system', __( 'No grading system found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * TutorLMS certification addon is not enabled.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function certification_addon_not_enabled() {
		return new WP_Error( 'tutor_json_certification_addon_not_enabled', __( 'TutorLMS certification addon is not enabled.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}
}
