<?php
/**
 * Holds TutorLMS rest controller functionality.
 *
 * @package BuddyBossApp\Api\TutorLMS\V1\Core
 */

namespace BuddyBossApp\Api\TutorLMS\V1\Core;

use WP_Error;
use WP_REST_Controller;
use WP_REST_Request;

/**
 * TutorLMS rest controller.
 *
 * @since 2.2.80
 */
class TutorRestController extends WP_REST_Controller {

	/**
	 * API namespace.
	 *
	 * @var string
	 */
	protected $namespace = 'buddyboss-app/tutor/v1';

	/**
	 * Rest base.
	 *
	 * @var string
	 */
	protected $rest_base;

	/**
	 * Rest constructor.
	 *
	 * @since 2.2.80
	 */
	public function __construct() {
	}

	/**
	 * Register the component routes.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function register_routes() {
		return new WP_Error( 'invalid-method', sprintf( "%s '%s' %s", __( 'Method', 'buddyboss-app' ), __METHOD__, __( 'not implemented. Must be overridden in subclass.', 'buddyboss-app' ) ), array( 'status' => 405 ) );
	}

	/**
	 * Check if a given request has access to read /posts.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @since 2.2.80
	 *
	 * @return WP_Error|boolean
	 */
	public function get_items_permissions_check( $request ) {
		return true;
	}

	/**
	 * Check if a given request has access to read a post.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @since 2.2.80
	 * @return WP_Error|boolean
	 */
	public function get_item_permissions_check( $request ) {
		return true;
	}

	/**
	 * Check if we can read a post.
	 *
	 * Correctly handles posts with the inherited status.
	 *
	 * @param object $post Post object.
	 *
	 * @since 2.2.80
	 *
	 * @return boolean Can we read it?
	 */
	public function check_read_permission( $post ) {
		return true;
	}

	/**
	 * Get the query params for collections of endpoint.
	 *
	 * @since 2.2.80
	 *
	 * @return array
	 */
	public function get_collection_params() {
		$params                       = parent::get_collection_params();
		$params['context']['default'] = 'view';

		return $params;
	}

	/**
	 * Prepare links for the request.
	 *
	 * @param array $data item object.
	 *
	 * @since 2.2.80
	 *
	 * @return array Links for the given data.
	 */
	protected function prepare_links( $data ) {
		$base = sprintf( '/%s/%s', $this->namespace, $this->rest_base );

		// Entity meta.
		$links = array(
			'self'       => array(
				'href' => rest_url( trailingslashit( $base ) . $data['id'] ),
			),
			'collection' => array(
				'href' => rest_url( $base ),
			),
		);

		if ( ! empty( $data['author'] ) ) {
			$links['author'] = array(
				'href'       => rest_url( '/wp/v2/users/' . $data['author'] ),
				'embeddable' => true,
			);
		}

		return $links;
	}
}
