<?php
/**
 * Holds assignments error rest functionality.
 *
 * @package BuddyBossApp\Api\TutorLMS\V1\Assignments
 */

namespace BuddyBossApp\Api\TutorLMS\V1\Assignments;

use BuddyBossApp\RestErrors;
use WP_Error;

/**
 * Assignment error.
 */
class AssignmentsError {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return AssignmentsError
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * When user is not logged in this error message should be used.
	 *
	 * @return WP_Error
	 */
	public function user_not_logged_in() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When Assignment id not correct.
	 *
	 * @return WP_Error
	 */
	public function invalid_assignment_id() {
		return new WP_Error( 'tutor_json_assignment_invalid_id', __( 'Assignment not found.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When Assignment submission is deadline.
	 *
	 * @return WP_Error
	 */
	public function missed_submission_deadline() {
		return new WP_Error( 'tutor_json_assignment_missed_deadline', __( 'You have missed the submission deadline. Please contact the instructor for more information.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Assignment file upload permission.
	 *
	 * @since 1.7.2
	 * @return WP_Error
	 */
	public function invalid_upload_limit() {
		return new WP_Error( 'tutor_json_assignment_upload_limit', __( 'You have reached your maximum limit of uploading assignments', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Assignment already started.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function assignment_already_started() {
		return new WP_Error( 'tutor_json_assignment_already_started', __( 'Assignment already started.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Invalid submission id.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function invalid_submission_id() {
		return new WP_Error( 'tutor_json_invalid_submission_id', __( 'Invalid submission ID.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Assignment deadline expired.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function assignment_deadline_expired() {
		return new WP_Error( 'tutor_json_assignment_deadline_expired', __( 'Assignment deadline expired.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Assignment already evaluated.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function assignment_already_evaluated() {
		return new WP_Error( 'tutor_json_assignment_already_evaluated', __( 'Assignment already evaluated.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Assignment evaluation not allowed.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function course_not_enrolled() {
		return new WP_Error( 'tutor_json_course_not_enrolled', __( 'You are not enrolled in this course.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Assignment evaluation not allowed.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function assignment_empty_content() {
		return new WP_Error( 'tutor_json_assignment_empty_content', __( 'Assignment content shouldn’t be empty.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Assignment already submitted.
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function assignment_already_submitted() {
		return new WP_Error( 'tutor_json_assignment_already_submitted', __( 'Assignment already submitted.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Attachment delete failed
	 *
	 * @since 2.2.80
	 * @return WP_Error
	 */
	public function attachment_delete_failed() {
		return new WP_Error( 'tutor_json_attachment_delete_failed', __( 'Attachment delete failed.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Invalid file name.
	 *
	 * @since 2.2.80
	 *
	 * @return WP_Error
	 */
	public function invalid_file_name() {
		return new WP_Error( 'tutor_json_file_invalid', __( 'Invalid file name.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}
}
