<?php
/**
 * Holds user related API functionality.
 *
 * @package BuddyBossApp\Api\LearnDash\V1\User
 */

namespace BuddyBossApp\Api\LearnDash\V1\User;

/**
 * Class UserRest
 *
 * @package BuddyBossApp\Api\LearnDash\V1\User
 */
class UserRest {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * UserRest constructor.
	 */
	public function __construct() {
		add_filter( 'rest_user_query', array( $this, 'filter_teachers' ), 10, 2 );
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * Filter teachers.
	 *
	 * @param array            $prepared_args Array of arguments.
	 * @param \WP_REST_Request $request       Full details about the request.
	 *
	 * @return mixed
	 */
	public function filter_teachers( $prepared_args, $request ) {
		global $wpdb;

		if ( '1' === (string) $request['teachers'] ) {

			$args = array(
				'per_page' => $request['page'] * $prepared_args['number'],
			);

			$user_ids = $this->get_teachers( $args );

			if ( ! empty( $user_ids ) ) {
				$prepared_args['include'] = $user_ids;
			} else {
				$prepared_args['include'] = array( 0 );
			}

			$prepared_args['orderby'] = 'include';
			$prepared_args['order']   = 'asc';

		}

		return $prepared_args;
	}

	/**
	 * Get teachers.
	 *
	 * @param array $args Array of arguments.
	 *
	 * @return array
	 */
	private function get_teachers( $args ) {
		global $wpdb;

		$limit    = isset( $args['per_page'] ) ? (int) $args['per_page'] : 5;
		$result   = $wpdb->get_results( $wpdb->prepare( "SELECT u.post_author as post_author, COUNT(*) as count FROM {$wpdb->prefix}posts u WHERE (post_type = 'sfwd-courses' and post_status = 'publish' ) AND u.post_author IN (SELECT ID FROM  {$wpdb->prefix}users WHERE ID=u.post_author) GROUP BY post_author ORDER BY count DESC LIMIT %d", $limit ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$user_ids = array();
		if ( ! empty( $result ) ) {
			foreach ( $result as $r ) {
				$user_ids[] = $r->post_author;
			}
		}

		return $user_ids;
	}
}
