<?php
/**
 * Holds LearnDash related API functionality.
 *
 * @package BuddyBossApp\Api\LearnDash\V1
 */

namespace BuddyBossApp\Api\LearnDash\V1;

// @todo - This need to have namespace and PSR-4 standards. By Ketan, Apr-2019

// Make sure we don't expose any info if called directly.
use BuddyBossApp\Api\LearnDash\V1\Assignments\AssignmentsActionRest;
use BuddyBossApp\Api\LearnDash\V1\Assignments\AssignmentsCommentRest;
use BuddyBossApp\Api\LearnDash\V1\Assignments\AssignmentsRest;
use BuddyBossApp\Api\LearnDash\V1\Certificate\CertificateRest;
use BuddyBossApp\Api\LearnDash\V1\Course\Category\CategoriesRest;
use BuddyBossApp\Api\LearnDash\V1\Course\CoursesActionRest;
use BuddyBossApp\Api\LearnDash\V1\Course\CoursesMembersRest;
use BuddyBossApp\Api\LearnDash\V1\Course\CoursesRest;
use BuddyBossApp\Api\LearnDash\V1\Lesson\LessonsActionRest;
use BuddyBossApp\Api\LearnDash\V1\Lesson\LessonsRest;
use BuddyBossApp\Api\LearnDash\V1\Quiz\LeaderboardRest;
use BuddyBossApp\Api\LearnDash\V1\Quiz\QuizQuestionsRest;
use BuddyBossApp\Api\LearnDash\V1\Quiz\QuizRest;
use BuddyBossApp\Api\LearnDash\V1\Quiz\QuizUserRest;
use BuddyBossApp\Api\LearnDash\V1\Statement\StatementRest;
use BuddyBossApp\Api\LearnDash\V1\Topic\TopicsActionRest;
use BuddyBossApp\Api\LearnDash\V1\Topic\TopicsRest;
use BuddyBossApp\Api\LearnDash\V1\User\UserRest;

if ( ! function_exists( 'add_action' ) ) {
	die( "Sorry, you can't access this directly - Security established" );
}

/**
 * Class RestAPI
 *
 * @package BuddyBossApp\Api\LearnDash\V1
 */
class RestAPI {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return RestAPI
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Load all rest routes.
	 */
	public function load() {
		// Register all hooks.
		$this->hooks();

	}

	/**
	 * Register all hooks
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function hooks() {
		add_action( 'rest_api_init', array( $this, 'load_rest' ) );
		add_filter( 'bbapp_set_cookies', array( $this, 'bbapp_set_cookies' ), 10, 2 );
	}

	/**
	 * Load all rest routes.
	 */
	public function load_rest() {
		CoursesRest::instance()->register_routes();
		CoursesActionRest::instance()->register_routes();
		CoursesMembersRest::instance()->register_routes();
		CategoriesRest::instance()->register_routes();

		LessonsRest::instance()->register_routes();
		LessonsActionRest::instance()->register_routes();

		TopicsRest::instance()->register_routes();
		TopicsActionRest::instance()->register_routes();

		QuizRest::instance()->register_routes();
		QuizQuestionsRest::instance()->register_routes();
		LeaderboardRest::instance()->register_routes();
		QuizUserRest::instance()->register_routes();

		StatementRest::instance()->register_routes();

		CertificateRest::instance()->register_routes();
		UserRest::instance();

		AssignmentsRest::instance()->register_routes();
		AssignmentsActionRest::instance()->register_routes();
		AssignmentsCommentRest::instance()->register_routes();

		$this->extend_object();
	}

	/**
	 * Allows only video progress cooke.
	 *
	 * @param array  $rest_cookies The cookies that are being set.
	 * @param string $route        The route that is being called.
	 *
	 * @return mixed
	 */
	public function bbapp_set_cookies( $rest_cookies, $route ) {
		if ( strpos( $route, 'learndash/v1/quiz' ) !== false ) {
			foreach ( $rest_cookies as $key => $value ) {
				if ( strpos( $key, 'learndash-video-progress' ) === false ) {
					unset( $rest_cookies[ $key ] );
				}
			}
		}
		return $rest_cookies;
	}

	/**
	 * Extend post object.
	 * 
	 * @since 1.8.40
	 */
	public function extend_object() {

		register_rest_field(
			array(
				'lesson',
				'ld_topic',
			),
			'comments_count',
			array(
				'get_callback' => array( $this, 'bbapp_comment_counts' ),
				'schema'       => array(
					'description' => 'Post comments count.',
					'type'        => 'integer',
					'context'     => array( 'embed', 'view', 'edit' ),
				),
			)
		);
	}

	/**
	 * Get the comments count for the post.
	 *
	 * @param WP_Post $post      Post object.
	 * @param string  $attribute The REST Field key used into the REST response.
	 * 
	 * @since 1.8.40
	 * @return int|string
	 */
	public function bbapp_comment_counts( $post, $attribute ) {
		$post_id = $post['id'];

		return (int) get_comments_number( $post_id );
	}
}
