<?php
/**
 * Holds Learndash user controller functionality.
 *
 * @package BuddyBossApp\Api\LearnDash\V1\Core
 */

namespace BuddyBossApp\Api\LearnDash\V1\Core;

use \WP_REST_Users_Controller;
use \WP_REST_Request;
use \WP_Error;

/**
 * Learndash user controller.
 */
class LDUserController extends WP_REST_Users_Controller {

	/**
	 * API namespace.
	 *
	 * @var string
	 */
	protected $namespace = 'buddyboss-app/learndash/v1';
	/**
	 * Rest base.
	 *
	 * @var string
	 */
	protected $rest_base;

	/**
	 * Rest constructor.
	 */
	public function __construct() {
		parent::__construct();
		$this->namespace = 'buddyboss-app/learndash/v1';
	}

	/**
	 * Register the component routes.
	 *
	 * @return WP_Error
	 */
	public function register_routes() {
		return new WP_Error( 'invalid-method', sprintf( "%s '%s' %s", __( 'Method', 'buddyboss-app' ), __METHOD__, __( 'not implemented. Must be overridden in subclass.', 'buddyboss-app' ) ), array( 'status' => 405 ) );
	}

	/**
	 * Get the query params for collections of endpoint.
	 *
	 * @return array
	 */
	public function get_collection_params() {

		$params = parent::get_collection_params();

		$params['context']['default'] = 'view';

		return $params;

	}

	/**
	 * Prepare links for the request.
	 *
	 * @param array|\WP_User $data item object.
	 *
	 * @return array Links for the given data.
	 */
	protected function prepare_links( $data ) {
		$links = parent::prepare_links( $data );
		return $links;
	}
}
