<?php
/**
 * Holds different shortcode support for LearnDash.
 *
 * @package BuddyBossApp\Api\LearnDash
 */

namespace BuddyBossApp\Api\LearnDash;

use Learndash_Course_Video;
use WP_Post;

/**
 * LearnDash short code support.
 */
class ShortcodeSupport {

	/**
	 * ShortcodeSupport constructor.
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Filters/hooks here.
	 */
	public function hooks() {
		add_action( 'rest_api_init', array( $this, 'api_init' ) );
		add_filter( 'rest_post_dispatch', array( $this, 'rest_post_dispatch' ), 10 );
	}

	/**
	 * Rest API init function.
	 */
	public function api_init() {
		// Tin Canny Shortcodde suppport for rest API.
		if ( defined( 'UNCANNY_REPORTING_VERSION' ) ) {
			$this->tincanny_shortcode_support();
		}

		// Learndahs LD_video support.
		add_filter( 'the_content', array( $this, 'add_ld_video_support' ), 9999 );
	}

	/**
	 * Tincanny shortcode support.
	 */
	public function tincanny_shortcode_support() {
		if ( class_exists( '\TINCANNYSNC\Shortcode' ) ) {
			new \TINCANNYSNC\Shortcode();
		}

		if ( class_exists( '\TINCANNYSNC\VisualComposer' ) ) {
			new \TINCANNYSNC\VisualComposer();
		}
	}

	/**
	 * Video content.
	 *
	 * @param string $content Video content.
	 *
	 * @return mixed
	 */
	public function add_ld_video_support( $content ) {
		global $post;

		if ( $post instanceof WP_Post && in_array( $post->post_type, array( 'sfwd-lessons', 'sfwd-topic' ), true ) ) {
			$topic_settings = learndash_get_setting( $post );

			if ( ( defined( 'LEARNDASH_LESSON_VIDEO' ) ) && ( true === LEARNDASH_LESSON_VIDEO ) && false !== strpos( $content, '[ld_video]' ) ) {
				$ld_course_videos = Learndash_Course_Video::get_instance();
				$content          = $ld_course_videos->add_video_to_content( $content, $post, $topic_settings );
			}
		}

		return $content;
	}

	/**
	 * Filters the rest content.
	 *
	 * @param string $result Result.
	 *
	 * @return mixed
	 */
	public function rest_post_dispatch( $result ) {
		add_filter( 'the_content', array( $this, 'add_scrom_support' ), 0 );

		return $result;
	}

	/**
	 * Add scrom content support.
	 *
	 * @param string $content Content.
	 *
	 * @return string|string[]
	 */
	public function add_scrom_support( $content ) {

		preg_match_all( '/\[vc_snc(.*)embed_type="(iframe|lightbox)"(.*)\]/', $content, $matches );

		foreach ( $matches[0] as $match ) {
			$pattern = get_shortcode_regex();
			preg_match_all( '/' . $pattern . '/s', $match, $items );
			if ( isset( $items[2] ) && ! empty( $items[3] ) ) {
				$item = shortcode_parse_atts( $items[3][0] );
				if ( empty( $item['href'] ) && ! empty( $item['src'] ) ) {
					$item['href'] = $item['src'];
				}

				if ( empty( $item['button_text'] ) ) {
					$item['button_text'] = '';
				}
				$new_str = '[vc_snc embed_type="_blank" item_id="' . $item['item_id'] . '" item_name="' . $item['item_name'] . '" button="text" button_text="' . $item['button_text'] . '" href="' . $item['href'] . '"]';

				$content = str_replace( $match, $new_str, $content );
			}
		}

		return $content;
	}

}
