<?php
/**
 * Holds LearnDash main class functionality.
 *
 * @package BuddyBossApp\Api\LearnDash
 */

namespace BuddyBossApp\Api\LearnDash;

use BuddyBossApp\Admin\Settings;
use BuddyBossApp\Api\LearnDash\V1\RestAPI as RestAPIv1;

/**
 * LearnDash API main class.
 */
class Main {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Register all hooks
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function hooks() {
		/**
		 * `LEARNDASH_VERSION` initialise on plugin loaded.
		 */
		add_action( 'plugins_loaded', array( $this, 'load' ) );
	}

	/**
	 * Load method.
	 */
	public function load() {

		if ( ! bbapp_is_learndash_enabled() ) {
			// don't load if leanrdash is not enabled.
			return false;
		}

		require_once dirname( __FILE__ ) . '/functions.php';
		require_once dirname( __FILE__ ) . '/LdFunctions.php';

		new LearndashCommon();

		$settings           = Settings::instance()->get_settings();
		$course_downloading = isset( $settings['learndash_course_downloading'] ) ? $settings['learndash_course_downloading'] : 0;

		if ( isset( $course_downloading ) && $course_downloading ) {
			new DisableOfflineSupport();
		}

		new HideInAppSupport();

		new ShortcodeSupport();
		RestAPIv1::instance();
	}
}
