<?php
/**
 * Class HideInAppSupport
 *
 * @package BuddyBossApp\Api\LearnDash
 */

namespace BuddyBossApp\Api\LearnDash;

use WP_Post;

/**
 * Class HideInAppSupport
 *
 * @package BuddyBossApp\Api\LearnDash
 */
class HideInAppSupport {

	/**
	 * HideInAppSupport constructor.
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Load hooks.
	 */
	public function hooks() {
		add_action( 'add_meta_boxes', array( $this, 'register_meta_boxes' ) );
		add_action( 'save_post', array( $this, 'save_meta_boxes' ) );
	}

	/**
	 * Register metaboxes.
	 */
	public function register_meta_boxes() {
		add_meta_box(
			'learndash_hide_in_app',
			__( 'Hide in App', 'buddyboss-app' ),
			array(
				$this,
				'hide_in_app_support_display',
			),
			'sfwd-courses',
			'side',
			'high'
		);
	}

	/**
	 * Hide in app display callback.
	 *
	 * @param WP_Post $post Post data.
	 */
	public function hide_in_app_support_display( $post ) {
		$_hide_in_app = get_post_meta( $post->ID, '_hide_in_app', true );
		?>
		<label for="title_field">
			<span class="components-checkbox-control__input-container">
				<input type="checkbox" name="course_hide_in_app" <?php echo checked( $_hide_in_app, 'yes' ); ?>id="course_hide_in_app" class="components-checkbox-control__input" value="yes"/>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" role="img" class="components-checkbox-control__checked" aria-hidden="true" focusable="false">
					<path d="M9 18.6L3.5 13l1-1L9 16.4l9.5-9.9 1 1z"></path>
				</svg>
			</span>
			<?php esc_html_e( 'Hide in app, unless user is enrolled', 'buddyboss-app' ); ?>
		</label>
		<?php
	}

	/**
	 * Save metabox.
	 *
	 * @param int $post_id Post id.
	 */
	public function save_meta_boxes( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		$action_post = ( ! empty( $_POST['action'] ) ) ? bbapp_input_clean( wp_unslash( $_POST['action'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

		if ( 'inline-save' === $action_post ) {
			return;
		}

		if ( 'sfwd-courses' === get_post_type( $post_id ) ) {
			$course_hide_in_app_post = ( ! empty( $_POST['course_hide_in_app'] ) ) ? bbapp_input_clean( wp_unslash( $_POST['course_hide_in_app'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

			if ( 'yes' === $course_hide_in_app_post ) {
				update_post_meta( $post_id, '_hide_in_app', 'yes' );
			} else {
				update_post_meta( $post_id, '_hide_in_app', 'no' );
			}
		}
	}
}
