<?php
/**
 * Holds Support for disable offline functionality.
 *
 * @package BuddyBossApp\Api\LearnDash
 */

namespace BuddyBossApp\Api\LearnDash;

/**
 * Support for disable offline controller.
 */
class DisableOfflineSupport {

	/**
	 * DisableOfflineSupport constructor.
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Define all Hooks.
	 */
	public function hooks() {
		add_action( 'add_meta_boxes', array( $this, 'register_meta_boxes' ) );
		add_action( 'save_post', array( $this, 'save_meta_boxes' ) );
	}

	/**
	 * Register metaboxes.
	 */
	public function register_meta_boxes() {
		add_meta_box(
			'learndash_disable_offline_support',
			__( 'Offline Downloading', 'buddyboss-app' ),
			array(
				$this,
				'disable_offline_support_display',
			),
			'sfwd-courses',
			'side',
			'high'
		);
	}

	/**
	 * HTML to disable offline support.
	 *
	 * @param object $post Post object.
	 */
	public function disable_offline_support_display( $post ) {
		$_is_disable_offline_support = get_post_meta( $post->ID, '_is_disable_offline_support', true );
		?>
		<label for="title_field">
			<span class="components-checkbox-control__input-container">
			<input type="checkbox" name="course_disable_offline" <?php echo checked( $_is_disable_offline_support, 'yes' ); ?>
				id="course_disable_offline" class="components-checkbox-control__input" value="yes"/>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" role="img" class="components-checkbox-control__checked" aria-hidden="true" focusable="false"><path d="M9 18.6L3.5 13l1-1L9 16.4l9.5-9.9 1 1z"></path></svg>
			</span>
			<?php esc_html_e( 'Disable offline support in app', 'buddyboss-app' ); ?>
		</label>
		<?php
	}

	/**
	 * Save disable offline option.
	 *
	 * @param int $post_id Post Id.
	 */
	public function save_meta_boxes( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}
		if ( isset( $_POST ) && isset( $_POST['action'] ) && 'inline-save' === $_POST['action'] ) { //phpcs:ignore WordPress.Security.NonceVerification.Missing
			return;
		}
		if ( 'sfwd-courses' === get_post_type( $post_id ) ) {
			if ( ! empty( $_POST['course_disable_offline'] ) && 'yes' === $_POST['course_disable_offline'] ) { //phpcs:ignore WordPress.Security.NonceVerification.Missing
				update_post_meta( $post_id, '_is_disable_offline_support', 'yes' );
			} else {
				update_post_meta( $post_id, '_is_disable_offline_support', 'no' );
			}
		}
	}
}
