<?php
/**
 * Class InAppPurchases Rest API.
 *
 * @package BuddyBossApp\Api\Core
 */

namespace BuddyBossApp\Api\InAppPurchases\V1;

use BuddyBossApp\Api\InAppPurchases\V1\Orders\OrdersRest;
use BuddyBossApp\Api\InAppPurchases\V1\Products\ProductsRest;

/**
 * Class RestAPI
 *
 * @package BuddyBossApp\Api\InAppPurchases\V1
 */
class RestAPI {

	/**
	 * Class instance.
	 *
	 * @var object
	 */
	protected static $instance;

	/**
	 * RestAPI constructor.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return mixed|object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Class hooks.
	 */
	public function hooks() {
		add_action( 'init', array( $this, 'init' ) );
	}

	/**
	 * Init Hooks.
	 */
	public function init() {
		OrdersRest::instance();
		ProductsRest::instance();
	}

}
