<?php
/**
 * Holds IAP related API functionality.
 *
 * @package BuddyBossApp\Api\InAppPurchases
 */

namespace BuddyBossApp\Api\InAppPurchases;

use BuddyBossApp\Api\InAppPurchases\V1\RestAPI as RestAPIv1;
use BuddyBossApp\Api\InAppPurchases\V2\RestAPI as RestAPIv2;

/**
 * Class Main
 *
 * @package BuddyBossApp\Api\InAppPurchases
 */
class Main {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Register all hooks
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function hooks() {
		add_action( 'plugins_loaded', array( $this, 'load' ) );
	}

	/**
	 * Load InAppPurchases API versions.
	 */
	public function load() {
		RestAPIv1::instance();
		RestAPIv2::instance();
	}
}
