<?php
/**
 * Class APP Rest API.
 *
 * @package BuddyBossApp\Api\Core
 */

namespace BuddyBossApp\Api\Deprecated;

/**
 * Class RestAPI
 *
 * @package BuddyBossApp\Api\Deprecated
 */
class RestAPI_1_1_0 {

	/**
	 * Class instance.
	 *
	 * @var object
	 */
	protected static $instance;

	/**
	 * RestAPI constructor.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return mixed|object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Class hooks.
	 */
	public function hooks() {
		add_action( 'rest_api_init', array( $this, 'registerRoutes' ), 99 );
		add_action( 'init', array( $this, 'init' ) );
	}

	/**
	 * Gamipress user supported.
	 */
	public function registerRoutes() {
		if ( ! class_exists( 'GamiPress' ) ) {
			return;
		}
		register_rest_field(
			'user',
			'points',
			array(
				'get_callback'    => array( $this, 'get_points' ),
				'update_callback' => null,
				'schema'          => null,
			)
		);
		register_rest_field(
			'bp_members',
			'points',
			array(
				'get_callback'    => array( $this, 'get_points' ),
				'update_callback' => null,
				'schema'          => null,
			)
		);
	}

	/**
	 * Get user total points
	 *
	 * @param $object
	 * @param $field_name
	 * @param $request
	 * @return array
	 */
	public function get_points( $object, $field_name, $request ) {
		$points       = 0;
		$points_types = gamipress_get_points_types();
		$types        = gamipress_get_points_types_slugs();
		if ( ! empty( $types ) ) {
			if ( count( $types ) == 1 ) {
				$points_type_slug = $types[0];
				$_point           = (int) gamipress_get_user_points( $object['id'], $points_type_slug );
				return array(
					'point'         => $_point,
					'label'         => ( $_point > 1 ) ? $points_types[ $points_type_slug ]['plural_name'] : $points_types[ $points_type_slug ]['singular_name'],
					'singular_name' => $points_types[ $points_type_slug ]['singular_name'],
					'plural_name'   => $points_types[ $points_type_slug ]['plural_name'],
				);
			} else {
				foreach ( $types as $type ) {
					$_point = (int) gamipress_get_user_points( $object['id'], $type );
					$points = $points + $_point;
				}
			}
		} else {
			$points = gamipress_get_user_points( $object['id'] );
		}
		return array(
			'point'         => $points,
			'label'         => ( $points > 1 ) ? __( 'Points', 'buddyboss-app' ) : __( 'Point', 'buddyboss-app' ),
			'singular_name' => __( 'Point', 'buddyboss-app' ),
			'plural_name'   => __( 'Points', 'buddyboss-app' ),
		);
	}


	/**
	 * Init Hooks.
	 */
	public function init() {
		add_filter( 'bbapp_settings_rest_response', array( $this, 'deprecated_fields' ), 10, 1 );
	}

	/**
	 * Deprecated fields support.
	 *
	 * @param \WP_REST_Response $response The response object.
	 *
	 * @return mixed
	 */
	public function deprecated_fields( $response ) {
		if ( isset( $response['iap'] ) ) {
			$response['iap']['terms_page_id'] = 0;
			$response['iap']['test_mode']     = false;
		}

		if ( ! isset( $response['languages'] ) ) {
			// Get language code from header using the common function.
			$language_code     = bbapp_get_app_language_header();
			$languages_strings = \BuddyBossApp\AppLanguages::instance()->get_languages_strings_by_language_code(
				array(
					'language_code' => $language_code,
				)
			);

			if ( is_wp_error( $languages_strings ) ) {
				$languages_strings                 = new \stdClass();
				$languages_strings->$language_code = new \stdClass();
			}
			$response['languages'] = $languages_strings;
		}

		return $response;
	}
}
