<?php
/**
 * Class Deprecated Rest Feature.
 *
 * @package BuddyBossApp\Api\Core
 */

namespace BuddyBossApp\Api\Deprecated;

/**
 * Class Main
 *
 * @package BuddyBossApp\Api\Deprecated
 */
class Main {

	/**
	 * Class instance.
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return mixed|object Class object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Load Rest API.
	 */
	public function load() {
		RestAPI_1_1_0::instance();
		add_action( 'init', array( $this, 'init' ) );
	}

	/**
	 * Init Hooks.
	 */
	public function init() {
		// It will render Gutenberg blocks for the AppPages.
		add_filter( 'bbapp_render_app_page_data', array( $this, 'deprecated_forums_block_settings' ), 10, 1 );
	}

	/**
	 * Function will support myforms parameter for the forum block settings in the old API.
	 * The myforms parameter has been removed since 1.2.0.
	 *
	 * @param $block_data
	 *
	 * @return mixed
	 * @deprecated since 1.2.0, use the author parameter instead with myforms.
	 */
	public function deprecated_forums_block_settings( $block_data ) {
		if ( ! empty( $block_data ) ) {
			if ( ! empty( $block_data['type'] ) ) {
				if ( 'bbapp/forums' === $block_data['type'] ) {
					$block_data['data']['data_source']['request_params']['myforms'] =  $block_data['data']['data_source']['request_params']['author'];
				}
			}
		}
		return $block_data;
	}

}
