<?php
/**
 * Main class for deeplinking.
 *
 * @package BuddyBossApp\Api\DeepLinking
 */

namespace BuddyBossApp\Api\DeepLinking;

use BuddyBossApp\Api\DeepLinking\V1\RestAPI as RestAPIv1;

/**
 * Class Main
 */
class Main {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Register all hooks
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function hooks() {
		add_action( 'plugins_loaded', array( $this, 'load' ) );
	}

	/**
	 * Load DeepLinking API versions.
	 */
	public function load() {
		RestAPIv1::instance();
	}
}
