<?php
/**
 * Class APP Rest API V1.
 *
 * @package BuddyBossApp\Api\Core
 */

namespace BuddyBossApp\Api\Core;

use BuddyBossApp\Api\Core\V1\RestAPI as RestAPIv1;

/**
 * Class Main
 *
 * @package BuddyBossApp\Api\Core
 */
class Main {

	/**
	 * Class instance.
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return mixed|object Class object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Load Rest API.
	 */
	public function load() {
		RestAPIv1::instance();
	}

}
