<?php
/**
 * Holds import/export functionality for iOSProvisioningProfiles.
 *
 * @package BuddyBossApp\Admin\Tools\ImportExport
 */

namespace BuddyBossApp\Admin\Tools\ImportExport;

use BuddyBossApp\Admin\Tools\ImportExport;
use BuddyBossApp\Helpers\BBAPP_File;

/**
 * Class iOSProvisioningProfiles.
 */
class iOSProvisioningProfiles { // phpcs:ignore PEAR.NamingConventions.ValidClassName.StartWithCapital, Generic.Classes.OpeningBraceSameLine.ContentAfterBrace

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Module name.
	 *
	 * @var $module_name
	 */
	private $module_name;

	/**
	 * Get the instance of the class.
	 *
	 * @return iOSProvisioningProfiles
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * IOS ProvisioningProfiles constructor.
	 */
	public function __construct() {
		// Using Singleton, see instance().
	}

	/**
	 * Instance load method.
	 */
	public function load() {
		$this->module_name = 'ios_provisioning_profiles';

		// Register The Module.
		ImportExport::instance()->module_register( $this->module_name, __( 'iOS Provisioning Profiles', 'buddyboss-app' ) );

		// Register the hooks for import and export data.
		ImportExport::instance()->hook_register(
			$this->module_name,
			array( $this, 'import' ),
			array( $this, 'export' )
		);
	}

	/**
	 * Import data function.
	 *
	 * @param array $data Import data.
	 *
	 * @return array
	 */
	public function import( $data ) {

		if ( isset( $data['data'][ $this->module_name ] ) ) {
			$uploaded_file_dir = ImportExport::instance()->get_bbapp_upload_dir();
			if ( ! is_array( $data['data'][ $this->module_name ] ) ) {
				$data['data'][ $this->module_name ] = array();
			}

			$global_settings = \BuddyBossApp\Admin\Settings::instance()->get_settings();
			foreach ( $data['data'][ $this->module_name ] as $key => $setting ) {
				$global_settings[ $key ] = ( 'publish.ios.provisioning_profile_automatic' === $key ) ? '' : $setting;
			}
			\BuddyBossApp\Admin\Settings::instance()->save_global_settings( $global_settings );

			// Clear fonts directory first.
			BBAPP_File::create_dir( $uploaded_file_dir );

			// Copy the files.
			foreach ( $data['assets'] as $file_name => $file_path ) {
				$copy_to_file_path = trailingslashit( $uploaded_file_dir ) . $file_name;
				BBAPP_File::copy_file( $file_path, $copy_to_file_path );
			}
		}

		return apply_filters( 'bbapp_import_ios_provisioning_profiles', $data );

	}

	/**
	 * Export data function.
	 *
	 * @param array $data Export data.
	 *
	 * @return array
	 */
	public function export( $data ) {

		$data['assets']      = array();
		$exportable_settings = ImportExport::instance()->get_exportable_settings( $this->module_name );
		$uploaded_file_dir   = ImportExport::instance()->get_bbapp_upload_dir();

		foreach ( $exportable_settings as $exportable_setting ) {
			if ( ! empty( $exportable_setting ) ) {
				$file_name = str_replace( '/bbapp/uploads/', '', $exportable_setting );
				$file_path = trailingslashit( $uploaded_file_dir ) . $file_name;
				if ( file_exists( $file_path ) ) {
					$data['assets'][ $file_name ] = $file_path;
				}
			}
		}
		$data['data'][ $this->module_name ] = $exportable_settings;

		return $data;
	}

}
