<?php
/**
 * Holds import/export functionality for Settings.
 *
 * @package BuddyBossApp\Admin\Tools\ImportExport
 */

namespace BuddyBossApp\Admin\Tools\ImportExport;

use BuddyBossApp\Admin\Tools\ImportExport;

/**
 * Class Settings.
 */
class Settings {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Module name.
	 *
	 * @var $module_name
	 */
	private $module_name;

	/**
	 * Get the instance of the class.
	 *
	 * @return Settings
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Branding constructor.
	 */
	public function __construct() {
		// Using Singleton, see instance().
	}

	/**
	 * Instance load method.
	 */
	public function load() {
		$this->module_name = 'settings';

		// Register The Module.
		ImportExport::instance()->module_register( $this->module_name, __( 'Settings', 'buddyboss-app' ) );

		// Register the hooks for import and export data.
		ImportExport::instance()->hook_register(
			$this->module_name,
			array( $this, 'import' ),
			array( $this, 'export' )
		);
	}

	/**
	 * Import data function.
	 *
	 * @param array $data Import data.
	 *
	 * @return array
	 */
	public function import( $data ) {

		if ( isset( $data['data'][ $this->module_name ] ) ) {

			if ( ! is_array( $data['data'][ $this->module_name ] ) ) {
				$data['data'][ $this->module_name ] = array();
			}

			if ( isset( $data['data'][ $this->module_name ]['global'] ) ) {
				$global_settings = \BuddyBossApp\Admin\Settings::instance()->get_settings();
				foreach ( $data['data'][ $this->module_name ]['global'] as $key => $setting ) {
					$global_settings[ $key ] = $setting;
				}
				\BuddyBossApp\Admin\Settings::instance()->save_global_settings( $global_settings );
			}
		}

		return apply_filters( 'bbapp_import_setting', $data );
	}

	/**
	 * Export data function.
	 *
	 * @param array $data Export data.
	 *
	 * @return array
	 */
	public function export( $data ) {
		$exportable_settings                = ImportExport::instance()->get_exportable_settings( $this->module_name );
		$data['data']['settings']['global'] = $exportable_settings;

		return apply_filters( 'bbapp_export_setting', $data );
	}


}
