<?php
/**
 * Holds import/export functionality for integration.
 *
 * @package BuddyBossApp\Admin\Tools\ImportExport
 */

namespace BuddyBossApp\Admin\Tools\ImportExport;

use BuddyBossApp\Admin\Tools\ImportExport;
use BuddyBossApp\Helpers\BBAPP_File;

/**
 * Import/Export class for integration.
 */
class Integrations {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Import/Export module name.
	 *
	 * @var $module_name
	 */
	private $module_name;

	/**
	 * Get the instance of the class.
	 *
	 * @return Integrations
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Branding constructor.
	 */
	public function __construct() {
		// Using Singleton, see instance().
	}

	/**
	 * Load method.
	 */
	public function load() {
		$this->module_name = 'integrations';

		// Register The Module.
		ImportExport::instance()->module_register( $this->module_name, __( 'Integrations', 'buddyboss-app' ) );

		// Register the hooks for import and export data.
		ImportExport::instance()->hook_register(
			$this->module_name,
			array( $this, 'import' ),
			array( $this, 'export' )
		);
	}

	/**
	 * Import data function.
	 *
	 * @param array $data Import data.
	 *
	 * @return array
	 */
	public function import( $data ) {

		if ( isset( $data['data']['integrations'] ) ) {

			if ( ! is_array( $data['data']['integrations'] ) ) {
				$data['data']['integrations'] = array();
			}

			if ( isset( $data['data']['settings']['integrations'] ) ) {
				$app_all_settings = \BuddyBossApp\Admin\Settings::instance()->get_settings();
				foreach ( $data['data']['settings']['integrations'] as $key => $setting ) {
					$app_all_settings[ $key ] = $setting;
				}
				\BuddyBossApp\Admin\Integrations::instance()->save_settings( $app_all_settings );
			}
		}

		$integration_dir = ImportExport::instance()->get_bbapp_upload_dir();

		// Clear fonts directory first.
		BBAPP_File::create_dir( $integration_dir );
		foreach ( $data['assets'] as $file_name => $file_path ) {
			$copy_to_file_path = trailingslashit( $integration_dir ) . $file_name;
			BBAPP_File::copy_file( $file_path, $copy_to_file_path );
		}

		return $data;
	}

	/**
	 * Export data function.
	 *
	 * @param array $data Export data.
	 *
	 * @return array
	 */
	public function export( $data ) {
		$integration_settings  = \BuddyBossApp\Admin\Integrations::instance()->get_settings();
		$exportable_files_list = array();
		$export_settings       = array();
		$exportable_settings   = ImportExport::instance()->bbapp_db_key_lists( 'integrations' );

		foreach ( $exportable_settings as $exportable_setting ) {
			if ( isset( $integration_settings[ $exportable_setting ] ) ) {
				$export_settings[ $exportable_setting ]       = $integration_settings[ $exportable_setting ];
				$exportable_files_list[ $exportable_setting ] = basename( $integration_settings[ $exportable_setting ] );
			}
		}

		$data['data']['integrations'] = $export_settings;
		$integration_dir              = ImportExport::instance()->get_bbapp_upload_dir();
		// Export Files.
		$objects = scandir( $integration_dir );

		foreach ( $objects as $object ) {
			if ( '.' !== $object && '..' !== $object ) {
				if ( in_array( $object, $exportable_files_list, true ) ) {
					$data['assets'][ $object ] = trailingslashit( $integration_dir ) . "/$object";
				}
			}
		}

		return $data;
	}

}
